<?php
require '../config.php'; // Incluye la configuración de la base de datos

try {
    // Consulta para obtener los datos de boletos vendidos por turno y vendedor del día actual
    $sql_boletos = "SELECT t.nombre AS turno, u.nombre AS vendedor, COUNT(v.id_venta) AS boletos_vendidos
                    FROM ventas v
                    JOIN turnos t ON v.id_turno = t.id_turno
                    JOIN usuarios u ON v.id_vendedor = u.id_usuario
                    WHERE DATE(v.fecha) = CURDATE()
                    GROUP BY t.nombre, u.nombre";
    $stmt_boletos = $pdo->query($sql_boletos);
    $boletos = $stmt_boletos->fetchAll(PDO::FETCH_ASSOC);

    // Consulta para obtener los ingresos por turno del día actual
    $sql_ingresos = "SELECT t.nombre AS turno, SUM(v.valor) AS ingresos
                     FROM ventas v
                     JOIN turnos t ON v.id_turno = t.id_turno
                     WHERE DATE(v.fecha) = CURDATE()
                     GROUP BY t.nombre";
    $stmt_ingresos = $pdo->query($sql_ingresos);
    $ingresos_data = $stmt_ingresos->fetchAll(PDO::FETCH_ASSOC);

    $ingresos = ['labels' => [], 'data' => []];
    foreach ($ingresos_data as $row) {
        $ingresos['labels'][] = $row['turno'];
        $ingresos['data'][] = $row['ingresos'];
    }

    // Consulta para obtener el total de ingresos y ganancias del día actual
    $sql_totales = "SELECT DATE(fecha) AS fecha, SUM(valor) AS total_ingresos, SUM(ganancia) AS ganancias
                    FROM ventas
                    WHERE DATE(fecha) = CURDATE()
                    GROUP BY DATE(fecha)";
    $stmt_totales = $pdo->query($sql_totales);
    $totales = $stmt_totales->fetchAll(PDO::FETCH_ASSOC);

    // Consulta para obtener los números vendidos por vendedor del día actual
    $sql_numeros = "SELECT u.nombre AS vendedor, v.numero, v.valor, v.fecha
                    FROM ventas v
                    JOIN usuarios u ON v.id_vendedor = u.id_usuario
                    WHERE DATE(v.fecha) = CURDATE()";
    $stmt_numeros = $pdo->query($sql_numeros);
    $numeros = $stmt_numeros->fetchAll(PDO::FETCH_ASSOC);

    // Devolver los datos en formato JSON
    echo json_encode([
        'boletos' => $boletos,
        'ingresos' => $ingresos,
        'totales' => $totales ?: [['fecha' => date('Y-m-d'), 'total_ingresos' => 0, 'ganancias' => 0]], // Evita errores si no hay datos
        'numeros' => $numeros
    ]);
} catch (PDOException $e) {
    // Manejo de errores
    echo json_encode(['error' => 'Error al obtener los datos: ' . $e->getMessage()]);
}
?>
