<?php
session_start();
require '../config.php';
require '../functions.php';

// Verificar si la caja está aperturada
if (!isCajaAperturada($pdo)) {
    header('Location: ../caja_no_aperturada.php');
    exit;
}

// Verifica si el usuario está autenticado
if (!isset($_SESSION['usuario_id'])) {
    header('Location: ../index.php');
    exit;
}

// Verifica si el usuario tiene permiso para acceder a la página
if (!usuarioTienePermiso($pdo, $_SESSION['usuario_id'], 'ver_datos')) {
    header('Location: ../sin_permiso.php');
    exit;
}
// Verifica los permisos del usuario para ver, editar y eliminar
$usuario_id = $_SESSION['usuario_id'];
$permisos = [
    'ver' => usuarioTienePermiso($pdo, $usuario_id, 'ver_datos'),
    'editar' => usuarioTienePermiso($pdo, $usuario_id, 'editar_datos'),
    'eliminar' => usuarioTienePermiso($pdo, $usuario_id, 'borrar_datos'),
];

?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Respaldo y Restauración de Base de Datos</title>
    <link rel="shortcut icon" href="../img/favi.ico">
    <link href="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css" rel="stylesheet">
    <style>
        .main-content {
            padding: 2rem;
        }
       
        .backup-buttons {
            text-align: center;
            margin-top: 30px;
        }
        .backup-buttons button {
            margin: 10px;
            padding: 15px 25px;
            font-size: 1.2rem;
        }
        .modal-confirm {
            color: #434e65;
            width: 400px;
        }
        .modal-confirm .modal-content {
            padding: 20px;
            border-radius: 5px;
            border: none;
        }
        .modal-confirm .modal-header {
            border-bottom: none;
            position: relative;
        }
        .modal-confirm h4 {
            text-align: center;
            font-size: 26px;
            margin: 30px 0 -15px;
        }
        .modal-confirm .close {
            position: absolute;
            top: -5px;
            right: -5px;
        }
        .modal-confirm .modal-footer {
            border: none;
            text-align: center;
            border-radius: 5px;
            font-size: 13px;
        }
        .modal-confirm .modal-footer a {
            color: #999;
        }
        .modal-confirm .icon-box {
            width: 80px;
            height: 80px;
            margin: 0 auto;
            border-radius: 50%;
            z-index: 9;
            text-align: center;
            border: 3px solid #f15e5e;
        }
        .modal-confirm .icon-box i {
            color: #f15e5e;
            font-size: 46px;
            display: inline-block;
            margin-top: 13px;
        }
        .modal-confirm.modal-dialog {
            margin-top: 80px;
        }
        .modal-confirm .btn {
            color: #fff;
            border-radius: 4px;
            background: #f15e5e;
            text-decoration: none;
            transition: all 0.4s;
            line-height: normal;
            border: none;
        }
        .modal-confirm .btn:hover, .modal-confirm .btn:focus {
            background: #ee3535;
            outline: none;
        }
        .modal-confirm .btn span {
            margin: 1px 5px;
            float: left;
        }
        .modal-confirm .btn i {
            margin-left: 1px;
            font-size: 20px;
            float: right;
        }
    </style>
</head>
<body>
    <?php include '../menu.php'; ?>

    <div class="container mt-4">
       
        <div class="d-flex align-items-center justify-content-center p-3 my-3 text-white bg-info rounded shadow-sm">
    <div class="lh-1 text-center">
        <h2 class="mb-4 text-center">
            <i class="fas fa-database"></i> <!-- Icono de FontAwesome -->
            Respaldo y Restauración de Base de Datos
        </h2>
    </div>
</div>


            <!-- Clean Tables Confirmation Modal -->
            <div id="cleanModal" class="modal fade" tabindex="-1" role="dialog">
                <div class="modal-dialog modal-confirm">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h4 class="modal-title">¿Limpiar Tablas?</h4>
                            <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
                        </div>
                        <div class="modal-body">
                            <p>¿Estás seguro de que deseas limpiar todas las tablas de la base de datos? Todos los datos se perderán.</p>
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancelar</button>
                            <button id="confirm-clean" type="button" class="btn btn-danger">Confirmar</button>
                        </div>
                    </div>
                </div>
            </div>

            <div class="backup-buttons">
                <button id="backup-btn" type="button" class="btn btn-info" data-toggle="modal" data-target="#backupModal">
                    <i class="fas fa-database"></i> Crear Respaldo
                </button>
                <button id="restore-btn" type="button" class="btn btn-success" data-toggle="modal" data-target="#restoreModal">
                    <i class="fas fa-upload"></i> Restaurar Respaldo
                </button>
                <button id="clean-btn" type="button" class="btn btn-danger" data-toggle="modal" data-target="#cleanModal">
                    <i class="fas fa-broom"></i> Limpiar Tablas
                </button>
            </div>
        
    </div>

    <!-- Backup Confirmation Modal -->
    <div id="backupModal" class="modal fade" tabindex="-1" role="dialog">
        <div class="modal-dialog modal-confirm">
            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="modal-title">¿Crear Respaldo?</h4>
                    <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
                </div>
                <div class="modal-body">
                    <p>¿Estás seguro de que deseas crear un respaldo de la base de datos actual? Esto puede tardar unos minutos.</p>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancelar</button>
                    <button id="confirm-backup" type="button" class="btn btn-primary">Confirmar</button>
                </div>
            </div>
        </div>
    </div>

    <!-- Restore Confirmation Modal -->
    <div id="restoreModal" class="modal fade" tabindex="-1" role="dialog">
        <div class="modal-dialog modal-confirm">
            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="modal-title">¿Restaurar Respaldo?</h4>
                    <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
                </div>
                <div class="modal-body">
                    <p>¿Estás seguro de que deseas restaurar el respaldo más reciente de la base de datos? Todos los cambios realizados después del último respaldo se perderán.</p>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancelar</button>
                    <button id="confirm-restore" type="button" class="btn btn-success">Confirmar</button>
                </div>
            </div>
        </div>
    </div>

    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>
    <script>
        $(document).ready(function () {
    // Respaldo de la base de datos
    $('#confirm-backup').click(function () {
        $.ajax({
            url: 'backup_db.php',
            type: 'POST',
            success: function (response) {
                var res = JSON.parse(response);
                if (res.status === 'success') {
                    alert('Respaldo creado con éxito.');
                    window.location.href = res.file; // Descargar el archivo de respaldo
                } else {
                    alert('Error: ' + res.message);
                }
                $('#backupModal').modal('hide');
            }
        });
    });

    // Restauración de la base de datos
    $('#confirm-restore').click(function () {
        $.ajax({
            url: 'restore_db.php',
            type: 'POST',
            success: function (response) {
                var res = JSON.parse(response);
                if (res.status === 'success') {
                    alert('Base de datos restaurada con éxito.');
                } else {
                    alert('Error: ' + res.message);
                }
                $('#restoreModal').modal('hide');
            }
        });
    });

    // Limpieza de las tablas
    $('#confirm-clean').click(function () {
        $.ajax({
            url: 'clear_tables.php',
            type: 'POST',
            success: function (response) {
                var res = JSON.parse(response);
                if (res.status === 'success') {
                    alert('Tablas limpiadas con éxito.');
                } else {
                    alert('Error: ' + res.message);
                }
                $('#cleanModal').modal('hide');
            }
        });
    });
});

    </script>
  
</body>
</html>
