<?php
require '../config.php';

function restore_database($pdo, $backupFile) {
    try {
        $sqlScript = file_get_contents($backupFile);
        $queries = explode(';', $sqlScript);

        foreach ($queries as $query) {
            if (trim($query) != '') {
                $pdo->exec($query);
            }
        }

        return true;
    } catch (Exception $e) {
        return $e->getMessage();
    }
}

$backupFile = '../backups/rentaautos_2023-08-10_15-30-00.sql'; // Archivo de respaldo que deseas restaurar
$result = restore_database($pdo, $backupFile);

if ($result === true) {
    echo json_encode(['status' => 'success']);
} else {
    echo json_encode(['status' => 'error', 'message' => "Error al restaurar la base de datos: $result"]);
}
?>
