<?php
session_start();
require '../config.php';

if (!isset($_SESSION['usuario_id'])) {
    header('Location: ../index.php');
    exit;
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $id_efectivo = $_POST['id_efectivo'];

    try {
        $stmt = $pdo->prepare("SELECT * FROM efectivo WHERE id_efectivo = :id_efectivo");
        $stmt->execute(['id_efectivo' => $id_efectivo]);
        $data = $stmt->fetch(PDO::FETCH_ASSOC);

        if ($data) {
            echo json_encode(['status' => 'success', 'data' => $data]);
        } else {
            echo json_encode(['status' => 'error', 'message' => 'No se encontraron datos.']);
        }
    } catch (PDOException $e) {
        echo json_encode(['status' => 'error', 'message' => 'Error al obtener datos.']);
    }
}
?>
