<?php
function isCajaAperturada($pdo) {
    // Obtener la última apertura de caja
    $sql = "SELECT fecha FROM caja WHERE tipo = 'apertura' ORDER BY fecha DESC LIMIT 1";
    $stmt = $pdo->query($sql);
    $apertura = $stmt->fetchColumn();

    if (!$apertura) {
        return false; // No hay aperturas registradas
    }

    // Verificar si la última apertura ha sido cerrada
    $sql = "SELECT COUNT(*) FROM caja WHERE tipo = 'cierre' AND fecha > :apertura";
    $stmt = $pdo->prepare($sql);
    $stmt->execute(['apertura' => $apertura]);
    $cierreCount = $stmt->fetchColumn();

    return $cierreCount == 0; // Si no hay cierres después de la última apertura, la caja está aperturada
}

// Obtener la moneda de la tabla empresa
function getMoneda($pdo) {
    $sql = "SELECT moneda FROM empresa LIMIT 1";
    $stmt = $pdo->query($sql);
    return $stmt->fetchColumn();
}

$moneda = getMoneda($pdo);

function formatMonto($moneda, $monto) {
    return  htmlspecialchars($moneda) . ' ' . number_format($monto, 2) ;
}

function obtenerTotalClientes($pdo) {
    $sql = "SELECT COUNT(*) as total FROM clientes";
    $stmt = $pdo->prepare($sql);
    $stmt->execute();
    $resultado = $stmt->fetch(PDO::FETCH_ASSOC);
    return $resultado['total'];
}

function obtenerTotalHabitaciones($pdo) {
    $sql = "SELECT COUNT(*) as total FROM habitaciones";
    $stmt = $pdo->prepare($sql);
    $stmt->execute();
    $resultado = $stmt->fetch(PDO::FETCH_ASSOC);
    return $resultado['total'];
}

function obtenerTotalReservasHoy($pdo) {
    $sql = "SELECT COUNT(*) as total FROM rentas WHERE DATE(fecha_registro) = CURDATE()";
    $stmt = $pdo->prepare($sql);
    $stmt->execute();
    $resultado = $stmt->fetch(PDO::FETCH_ASSOC);
    return $resultado['total'];
}


function obtenerTotalPagosHoy($pdo) {
    $sql = "SELECT SUM(monto) as total FROM pagos WHERE DATE(fecha_pago) = CURDATE()";
    $stmt = $pdo->prepare($sql);
    $stmt->execute();
    $resultado = $stmt->fetch(PDO::FETCH_ASSOC);
    return $resultado['total'] ? $resultado['total'] : 0; // Retorna 0 si no hay pagos
}

//Gestion de Permiso
function usuarioTienePermiso($pdo, $usuario_id, $nombre_permiso) {
    $query = "
        SELECT COUNT(*) 
        FROM usuarios_roles ur
        JOIN roles_permisos rp ON ur.id_rol = rp.id_rol
        JOIN permisos p ON rp.id_permiso = p.id_permiso
        WHERE ur.id_usuario = :id_usuario AND p.nombre_permiso = :nombre_permiso
    ";
    $stmt = $pdo->prepare($query);
    $stmt->execute([':id_usuario' => $usuario_id, ':nombre_permiso' => $nombre_permiso]);
    return $stmt->fetchColumn() > 0;
}

function formatearFecha($fecha) {
    // Convierte la fecha a un objeto DateTime
    $fechaObj = new DateTime($fecha);
    // Devuelve la fecha en un formato más legible y abreviado: "d de M de aaaa"
    return $fechaObj->format('d') . ' de ' . $fechaObj->format('M') . ' de ' . $fechaObj->format('Y');
}

function calcularGanancia($valor) {
    $tabla_ganancias = [
        "0.25" => 17,     "0.50" => 35,     "0.75" => 55,     "1.00" => 70,
        "1.25" => 87,     "1.50" => 105,    "1.75" => 122,    "2.00" => 140,
        "2.25" => 157,    "2.50" => 175,    "2.75" => 192,    "3.00" => 210,
        "3.25" => 227,    "3.50" => 245,    "3.75" => 262,    "4.00" => 280,
        "4.25" => 297,    "4.50" => 315,    "4.75" => 332,    "5.00" => 350,

        "5.25" => 367,    "5.50" => 385,    "5.75" => 402,    "6.00" => 420,
        "6.25" => 437,    "6.50" => 455,    "6.75" => 472,    "7.00" => 490,
        "7.25" => 507,    "7.50" => 525,    "7.75" => 542,    "8.00" => 560,
        "8.25" => 577,    "8.50" => 595,    "8.75" => 612,    "9.00" => 630,
        "9.25" => 647,    "9.50" => 665,    "9.75" => 682,    "10.00" => 700,

        "10.25" => 717,   "10.50" => 735,   "10.75" => 752,   "11.00" => 770,
        "11.25" => 787,   "11.50" => 805,   "11.75" => 822,   "12.00" => 840,
        "12.25" => 857,   "12.50" => 875,   "12.75" => 892,   "13.00" => 910,
        "13.25" => 927,   "13.50" => 945,   "13.75" => 962,   "14.00" => 980,
        "14.25" => 997,   "14.50" => 1_015, "14.75" => 1_032, "15.00" => 1_050,

        "15.25" => 1_067, "15.50" => 1_085, "15.75" => 1_102, "16.00" => 1_120,
        "16.25" => 1_137, "16.50" => 1_155, "16.75" => 1_172, "17.00" => 1_190,
        "17.25" => 1_207, "17.50" => 1_225, "17.75" => 1_242, "18.00" => 1_260,
        "18.25" => 1_277, "18.50" => 1_295, "18.75" => 1_312, "19.00" => 1_330,
        "19.25" => 1_347, "19.50" => 1_365, "19.75" => 1_382, "20.00" => 1_400,

        "20.25" => 1_417, "20.50" => 1_435, "20.75" => 1_452, "21.00" => 1_470,
        "21.25" => 1_487, "21.50" => 1_505, "21.75" => 1_522, "22.00" => 1_540,
        "22.25" => 1_557, "22.50" => 1_575, "22.75" => 1_592, "23.00" => 1_610,
        "23.25" => 1_627, "23.50" => 1_645, "23.75" => 1_662, "24.00" => 1_680,
        "24.25" => 1_697, "24.50" => 1_715, "24.75" => 1_732, "25.00" => 1_750,

        "25.25" => 1_767, "25.50" => 1_785, "25.75" => 1_802, "26.00" => 1_820,
        "26.25" => 1_837, "26.50" => 1_855, "26.75" => 1_872, "27.00" => 1_890,
        "27.25" => 1_907, "27.50" => 1_925, "27.75" => 1_942, "28.00" => 1_960,
        "28.25" => 1_977, "28.50" => 1_995, "28.75" => 2_013, "29.00" => 2_030,
        "29.25" => 2_047, "29.50" => 2_065, "29.75" => 2_082, "30.00" => 2_100
    ];

    $tabla_ganancias2 = [
        "0.25" => 20,  "0.50" => 40,  "0.75" => 60,  "1.00" => 80,
        "1.25" => 100, "1.50" => 120, "1.75" => 140, "2.00" => 160,
        "2.25" => 180, "2.50" => 200, "2.75" => 220, "3.00" => 240,
        "3.25" => 260, "3.50" => 280, "3.75" => 300, "4.00" => 320,
        "4.25" => 340, "4.50" => 360, "4.75" => 380, "5.00" => 400,
    
        "5.25" => 420, "5.50" => 440, "5.75" => 460, "6.00" => 480,
        "6.25" => 500, "6.50" => 520, "6.75" => 540, "7.00" => 560,
        "7.25" => 580, "7.50" => 600, "7.75" => 620, "8.00" => 640,
        "8.25" => 660, "8.50" => 680, "8.75" => 700, "9.00" => 720,
        "9.25" => 740, "9.50" => 760, "9.75" => 780, "10.00" => 800,
    
        "10.25" => 820, "10.50" => 840, "10.75" => 860, "11.00" => 880,
        "11.25" => 900, "11.50" => 920, "11.75" => 940, "12.00" => 960,
        "12.25" => 980, "12.50" => 1000, "12.75" => 1020, "13.00" => 1040,
        "13.25" => 1060, "13.50" => 1080, "13.75" => 1100, "14.00" => 1120,
        "14.25" => 1140, "14.50" => 1160, "14.75" => 1180, "15.00" => 1200,
    
        "15.25" => 1220, "15.50" => 1240, "15.75" => 1260, "16.00" => 1280,
        "16.25" => 1300, "16.50" => 1320, "16.75" => 1340, "17.00" => 1360,
        "17.25" => 1380, "17.50" => 1400, "17.75" => 1420, "18.00" => 1440,
        "18.25" => 1460, "18.50" => 1480, "18.75" => 1500, "19.00" => 1520,
        "19.25" => 1540, "19.50" => 1560, "19.75" => 1580, "20.00" => 1600,
    
        "20.25" => 1620, "20.50" => 1640, "20.75" => 1660, "21.00" => 1680,
        "21.25" => 1700, "21.50" => 1720, "21.75" => 1740, "22.00" => 1760,
        "22.25" => 1780, "22.50" => 1800, "22.75" => 1820, "23.00" => 1840,
        "23.25" => 1860, "23.50" => 1880, "23.75" => 1900, "24.00" => 1920,
        "24.25" => 1940, "24.50" => 1960, "24.75" => 1980, "25.00" => 2000,
    
        "25.25" => 2020, "25.50" => 2040, "25.75" => 2060, "26.00" => 2080,
        "26.25" => 2100, "26.50" => 2120, "26.75" => 2140, "27.00" => 2160,
        "27.25" => 2180, "27.50" => 2200, "27.75" => 2220, "28.00" => 2240,
        "28.25" => 2260, "28.50" => 2280, "28.75" => 2300, "29.00" => 2320,
        "29.25" => 2340, "29.50" => 2360, "29.75" => 2380, "30.00" => 2400
    ];
    
    

    // Asegurar formato correcto con 2 decimales
    $valor = number_format((float)$valor, 2, '.', '');

    // Si el valor exacto existe en la tabla, devolverlo directamente
    if (array_key_exists($valor, $tabla_ganancias)) {
        return $tabla_ganancias[$valor];
    }

    // Si no está, buscar el mayor valor menor o igual
    $valores_disponibles = array_keys($tabla_ganancias);
    rsort($valores_disponibles); // Ordenar de mayor a menor

    foreach ($valores_disponibles as $v) {
        if (bccomp($valor, $v, 2) >= 0) {  // Compara con precisión de 2 decimales
            return $tabla_ganancias[$v];
        }
    }

    return 0; // Si no hay coincidencias, devolver 0
}

function calcularGanancia2($valor) {

    $tabla_ganancias = [
        "0.25" => 20,  "0.50" => 40,  "0.75" => 60,  "1.00" => 80,
        "1.25" => 100, "1.50" => 120, "1.75" => 140, "2.00" => 160,
        "2.25" => 180, "2.50" => 200, "2.75" => 220, "3.00" => 240,
        "3.25" => 260, "3.50" => 280, "3.75" => 300, "4.00" => 320,
        "4.25" => 340, "4.50" => 360, "4.75" => 380, "5.00" => 400,
    
        "5.25" => 420, "5.50" => 440, "5.75" => 460, "6.00" => 480,
        "6.25" => 500, "6.50" => 520, "6.75" => 540, "7.00" => 560,
        "7.25" => 580, "7.50" => 600, "7.75" => 620, "8.00" => 640,
        "8.25" => 660, "8.50" => 680, "8.75" => 700, "9.00" => 720,
        "9.25" => 740, "9.50" => 760, "9.75" => 780, "10.00" => 800,
    
        "10.25" => 820, "10.50" => 840, "10.75" => 860, "11.00" => 880,
        "11.25" => 900, "11.50" => 920, "11.75" => 940, "12.00" => 960,
        "12.25" => 980, "12.50" => 1000, "12.75" => 1020, "13.00" => 1040,
        "13.25" => 1060, "13.50" => 1080, "13.75" => 1100, "14.00" => 1120,
        "14.25" => 1140, "14.50" => 1160, "14.75" => 1180, "15.00" => 1200,
    
        "15.25" => 1220, "15.50" => 1240, "15.75" => 1260, "16.00" => 1280,
        "16.25" => 1300, "16.50" => 1320, "16.75" => 1340, "17.00" => 1360,
        "17.25" => 1380, "17.50" => 1400, "17.75" => 1420, "18.00" => 1440,
        "18.25" => 1460, "18.50" => 1480, "18.75" => 1500, "19.00" => 1520,
        "19.25" => 1540, "19.50" => 1560, "19.75" => 1580, "20.00" => 1600,
    
        "20.25" => 1620, "20.50" => 1640, "20.75" => 1660, "21.00" => 1680,
        "21.25" => 1700, "21.50" => 1720, "21.75" => 1740, "22.00" => 1760,
        "22.25" => 1780, "22.50" => 1800, "22.75" => 1820, "23.00" => 1840,
        "23.25" => 1860, "23.50" => 1880, "23.75" => 1900, "24.00" => 1920,
        "24.25" => 1940, "24.50" => 1960, "24.75" => 1980, "25.00" => 2000,
    
        "25.25" => 2020, "25.50" => 2040, "25.75" => 2060, "26.00" => 2080,
        "26.25" => 2100, "26.50" => 2120, "26.75" => 2140, "27.00" => 2160,
        "27.25" => 2180, "27.50" => 2200, "27.75" => 2220, "28.00" => 2240,
        "28.25" => 2260, "28.50" => 2280, "28.75" => 2300, "29.00" => 2320,
        "29.25" => 2340, "29.50" => 2360, "29.75" => 2380, "30.00" => 2400
    ];
    
    

    // Asegurar formato correcto con 2 decimales
    $valor = number_format((float)$valor, 2, '.', '');

    // Si el valor exacto existe en la tabla, devolverlo directamente
    if (array_key_exists($valor, $tabla_ganancias)) {
        return $tabla_ganancias[$valor];
    }

    // Si no está, buscar el mayor valor menor o igual
    $valores_disponibles = array_keys($tabla_ganancias);
    rsort($valores_disponibles); // Ordenar de mayor a menor

    foreach ($valores_disponibles as $v) {
        if (bccomp($valor, $v, 2) >= 0) {  // Compara con precisión de 2 decimales
            return $tabla_ganancias[$v];
        }
    }

    return 0; // Si no hay coincidencias, devolver 0
}

function fecha_en_espanol() {
    // Intentar establecer la localización en español
    if (stristr(PHP_OS, 'win')) {
        setlocale(LC_TIME, 'spanish'); // Para Windows
    } else {
        setlocale(LC_TIME, 'es_ES.UTF-8'); // Para Linux/Unix
    }
    return strftime('%e de %B de %Y'); // Formato: 3 de marzo de 2025
}

