$(document).ready(function() {
    function loadTable(page = 1) {
        $.ajax({
            url: 'crud_pagos.php',
            type: 'POST',
            data: { page: page }, // Enviar el número de página actual
            success: function(response) {
                $('#paymentTableBody').html($(response).find('#paymentTableBody').html());
            }
        });
    }
    // Manejar la búsqueda en tiempo real
    $('#searchInput').on('keyup', function() {
        var search = $(this).val();
        $.ajax({
            url: 'search_pago.php', // Archivo para buscar pagos
            type: 'POST',
            data: { search: search },
            success: function(response) {
                $('#paymentTableBody').html(response); // Actualiza el cuerpo de la tabla de pagos
            }
        });
    });

    $('#searchForm').on('submit', function(e) {
        e.preventDefault(); // Evita la recarga de la página

        // Obtén los valores del formulario
        var search = $('#searchInput').val();
        var fechaInicio = $('#fechaInicio').val();
        var fechaFin = $('#fechaFin').val();

        // Realiza la solicitud AJAX
        $.ajax({
            url: 'buscar_pagos.php', // Cambia esto por la URL del archivo PHP que manejará la búsqueda
            type: 'POST',
            data: {
                search: search,
                fecha_inicio: fechaInicio,
                fecha_fin: fechaFin
            },
            success: function(response) {
                // Actualiza la tabla con la respuesta del servidor
                $('#paymentTableBody').html(response);
            },
            error: function() {
                alert('Hubo un error al procesar la solicitud.');
            }
        });
    });
    
        // Puedes agregar un evento de cambio en las fechas también si deseas
        $('#fechaInicio, #fechaFin').on('change', function() {
            // Obtén los valores del formulario
            var search = $('#searchInput').val();
            var fechaInicio = $('#fechaInicio').val();
            var fechaFin = $('#fechaFin').val();
    
            // Realiza la solicitud AJAX
            $.ajax({
                url: 'buscar_pagos.php', // Cambia esto por la URL del archivo PHP que manejará la búsqueda
                type: 'POST',
                data: {
                    search: search,
                    fecha_inicio: fechaInicio,
                    fecha_fin: fechaFin
                },
                success: function(response) {
                    // Actualiza la tabla con la respuesta del servidor
                    $('#paymentTableBody').html(response);
                },
                error: function() {
                    alert('Hubo un error al procesar la solicitud.');
                }
            });
        });

   // Manejar la edición de pagos
$(document).on('click', '.edit-btn', function() {
    var id = $(this).data('id');
    $.ajax({
        url: 'get_pago.php', // Archivo para obtener datos del pago
        type: 'POST',
        data: { id_pago: id },
        dataType: 'json',
        success: function(response) {
            if (response.status === 'success') {
                var data = response.data;
                $('#editId').val(data.id_pago);
                // Concatenar el nombre y apellido del cliente y del usuario
                $('#editClienteNombre').val(data.cliente_nombre + ' ' + data.cliente_apellido);  
                $('#editUsuarioNombre').val(data.usuario_nombre + ' ' + data.usuario_apellido);
                $('#editMonto').val(data.monto);
                // Ajustar formato de fecha para datetime-local (YYYY-MM-DDTHH:MM)
                var fechaPago = new Date(data.fecha_pago);
                var formattedDate = fechaPago.toISOString().slice(0, 16); // Formato correcto para datetime-local
                $('#editFechaPago').val(formattedDate);
                $('#editMetodoPago').val(data.metodo_pago);
                $('#editEstado').val(data.estado);
                $('#editModal').modal('show');
            } else {
                showMessage('alert-danger', 'Error al obtener datos del pago.');
            }
        }
    });
});


    // Confirmar eliminación de pago
    $(document).on('click', '.delete-btn', function() {
        var paymentId = $(this).data('id');
        var confirmation = confirm('¿Estás seguro de que deseas eliminar este pago?');

        if (confirmation) {
            $.ajax({
                url: 'delete_pago.php', // Archivo para eliminar pagos
                type: 'POST',
                data: { id_pago: paymentId },
                success: function(response) {
                    if (response === 'success') {
                        showMessage('alert-success', 'Pago eliminado exitosamente.');
                        $('#searchInput').trigger('keyup');
                    } else {
                        showMessage('alert-danger', 'Error al eliminar el pago.');
                    }
                }
            });
        }
    });

    // Manejar el envío del formulario de edición
    $('#editForm').on('submit', function(e) {
        e.preventDefault();

        $.ajax({
            url: 'update_pago.php', // Archivo para actualizar pagos
            type: 'POST',
            data: $(this).serialize(),
            success: function(response) {
                if (response === 'success') {
                    showMessage('alert-success', 'Pago actualizado exitosamente.');
                    $('#editModal').modal('hide');
                    loadTable(); // Actualizar la tabla
                } else {
                    showMessage('alert-danger', 'Error al actualizar el pago.');
                }
            }
        });
    });
    


    // Manejar el envío del formulario para agregar un pago
    $('#addForm').on('submit', function(e) {
        e.preventDefault();

        $.ajax({
            url: 'add_pago.php', // Archivo para agregar pagos
            type: 'POST',
            data: $(this).serialize(),
            success: function(response) {
                if (response === 'success') {
                    showMessage('alert-success', 'Pago agregado exitosamente.');
                    $('#addModal').modal('hide');
                    $('#searchInput').trigger('keyup');
                } else {
                    showMessage('alert-danger', 'Error al agregar el pago.');
                }
            }
        });
    });

    function showMessage(type, text) {
        var message = $('#message');
        message.removeClass('d-none').removeClass('alert-success').removeClass('alert-danger');
        message.addClass(type).text(text);

        setTimeout(function() {
            message.addClass('d-none');
        }, 5000);
    }

    $(document).on('click', '.page-link', function(e) {
        e.preventDefault();
        var page = $(this).data('page');
        loadTable(page); // Actualizar la tabla con la página seleccionada
    });

     // Manejar la búsqueda con el botón de búsqueda
     $('#searchButton').on('click', function() {
        $.ajax({
            url: 'buscar_pagos.php',
            type: 'POST',
            data: $('#searchForm').serialize(),
            success: function(data) {
                var pagos = JSON.parse(data);
                var tableBody = $('#paymentTableBody');
                tableBody.empty();
                pagos.forEach(function(pago) {
                    tableBody.append('<tr>' +
                        '<td>' + pago.id_pago + '</td>' +
                        '<td>' + pago.nombre_cliente + ' ' + pago.apellido_cliente + '</td>' +
                        '<td>' + pago.nombre_usuario + ' ' + pago.apellido_usuario + '</td>' +
                        '<td>' + pago.monto + '</td>' +
                        '<td>' + pago.fecha_pago + '</td>' +
                        '<td>' + pago.metodo_pago + '</td>' +
                        '<td>' + pago.estado + '</td>' +
                        '<td>' +
                        '<div class="btn-group">' +
                        '<button class="btn btn-warning btn-sm edit-btn" data-id="' + pago.id_pago + '" data-toggle="modal" data-target="#editModal"><i class="fas fa-edit"></i></button> ' +
                        '<button class="btn btn-danger btn-sm delete-btn" data-id="' + pago.id_pago + '"><i class="fas fa-trash-alt"></i></button> ' +
                        '<button class="btn btn-success btn-sm reprint-btn" data-id="' + pago.id_pago + '"><i class="fas fa-print"></i></button>' +
                        '</div>' +
                        '</td>' +
                        '</tr>');
                });
                
            }
        });
    });
    
    // Maneja el clic en el botón "Reimprimir"
    $(document).on('click', '.reprint-btn', function() {
        var idPago = $(this).data('id');

        // Realiza la solicitud AJAX para obtener el HTML del ticket
        $.ajax({
            url: 'reprint_ticket.php',
            type: 'GET',
            data: { id_pago: idPago },
            success: function(response) {
                // Abre una nueva ventana para el ticket
                var mywindow = window.open('', 'Ticket de Pago', 'height=800,width=800');
                mywindow.document.write('<html><head><title>Ticket de Pago</title>');
                mywindow.document.write('</head><body>');
                mywindow.document.write(response); // Escribe el HTML del ticket en la nueva ventana
                mywindow.document.write('</body></html>');
                mywindow.document.close(); // necessary for IE >= 10
                mywindow.focus(); // necessary for IE >= 10
                mywindow.print();
                mywindow.close();
            },
            error: function() {
                alert('Error al generar el ticket.');
            }
        });
    });
    

});

