<?php
require '../config.php';

if (isset($_GET['id_renta'])) {
    $id_renta = $_GET['id_renta'];

    $sql = "SELECT r.id_renta, r.fecha_renta, r.fecha_devolucion, r.precio_total, r.pago,
                   c.id_cliente, c.nombre AS nombre_cliente, c.apellido AS apellido_cliente, 
                   a.nombre_habitacion AS marca_auto, a.numero_habitacion AS modelo_auto, a.tipo AS tipo_auto, a.precio_diario AS auto_precio
            FROM rentas r
            JOIN clientes c ON r.id_cliente = c.id_cliente
            JOIN habitaciones a ON r.id_auto = a.id_habitacion
            WHERE r.id_renta = ?";
    
    $stmt = $pdo->prepare($sql);
    $stmt->execute([$id_renta]);
    $renta = $stmt->fetch(PDO::FETCH_ASSOC);
    
    $stmt = $pdo->prepare($sql);
    $stmt->execute([$id_renta]);
    $renta = $stmt->fetch(PDO::FETCH_ASSOC);

    if ($renta) {
        echo json_encode($renta);
    } else {
        echo json_encode(['error' => 'No se encontraron detalles de la reservación.']);
    }
}
?>
