$(document).ready(function() {

    // Manejar el clic en el botón de detalles
$(document).on('click', '.details-btn', function() {
    const idRenta = $(this).data('id');

    // Solicitud AJAX para obtener los detalles de la reservación
    $.ajax({
        url: 'get_reservation_details.php',
        type: 'GET',
        data: { id_renta: idRenta },
        dataType: 'json',
        success: function(data) {
            // Formatear fechas para ser más legibles
            const fechaRenta = new Date(data.fecha_renta).toLocaleDateString('es-ES');
            const fechaDevolucion = new Date(data.fecha_devolucion).toLocaleDateString('es-ES');

            // Calcular días de renta
            const diasRenta = Math.round((new Date(data.fecha_devolucion) - new Date(data.fecha_renta)) / (1000 * 60 * 60 * 24));

            $('#reservationDetails').html(`
                <table class="table table-bordered">
                    <tbody>
                        <tr>
                            <td><strong>ID Reservación:</strong></td>
                            <td>${data.id_renta}</td>
                        </tr>
                        <tr>
                            <td><strong>Cliente:</strong></td>
                            <td>${data.nombre_cliente} ${data.apellido_cliente}</td>
                        </tr>
                        <tr>
                            <td><strong>Auto:</strong></td>
                            <td>${data.marca_auto} ${data.modelo_auto} ${data.tipo_auto}</td>
                        </tr>
                        <tr>
                            <td><strong>Precio/Dia:</strong></td>
                            <td>${data.auto_precio}</td>

                        </tr>
                        <tr>
                            <td><strong>Fecha de check-in:</strong></td>
                            <td>${fechaRenta}</td>
                        </tr>
                        <tr>
                            <td><strong>Fecha de check-out:</strong></td>
                            <td>${fechaDevolucion}</td>
                        </tr>
                        <tr>
                            <td><strong>Estadía:</strong></td>
                            <td>${diasRenta} días</td>
                        </tr>
                        <tr>
                            <td><strong>Precio Total:</strong></td>
                            <td>${data.precio_total}</td>
                        </tr>
                        <tr>
                            <td><strong>Pago:</strong></td>
                            <td>${data.pago}</td>
                        </tr>
                    </tbody>
                </table>
            `);

            // Setear los valores ocultos para el formulario de pago
            $('#id_cliente').val(data.id_cliente);
            $('#id_renta').val(data.id_renta);

            $('#detailsModal').modal('show'); // Mostrar el modal
        },
        error: function() {
            alert('Error al obtener los detalles.');
        }
    });
});

 // Manejar el envío del formulario de cobro
$('#paymentForm').on('submit', function(event) {
    event.preventDefault();
    const idCliente = $('#id_cliente').val();
    const idRenta = $('#id_renta').val();
    const amount = $('#amount').val();
    const metodoPago = $('#metodo_pago').val();

    // Referencia al botón de envío
    const $boton = $('#submitButton');

    // Cambiar el contenido del botón para mostrar el spinner y el texto "Enviando..."
    $boton.html('<i class="fas fa-spinner fa-spin"></i> Enviando...').prop('disabled', true);

    // Enviar el formulario de cobro al servidor
    $.ajax({
        url: 'process_payment.php',
        type: 'POST',
        data: {
            id_cliente: idCliente,
            id_renta: idRenta,
            monto: amount,
            metodo_pago: metodoPago
        },
        success: function(response) {
            // Abrir una nueva ventana para el ticket
            var mywindow = window.open('', 'Ticket de Pago', 'height=800,width=800');
            mywindow.document.write('<html><head><title>Ticket de Pago</title>');
            mywindow.document.write('</head><body>');
            mywindow.document.write(response); // Asumiendo que `response` contiene el HTML del ticket
            mywindow.document.write('</body></html>');
            mywindow.document.close(); // necessary for IE >= 10
            mywindow.focus(); // necessary for IE >= 10
            mywindow.print();
            mywindow.close();

            // Mostrar mensaje de éxito
            showMessage('alert-success', 'Pago realizado con éxito.');

            // Ocultar el modal y limpiar el formulario
            $('#detailsModal').modal('hide');
            $('#paymentForm')[0].reset();
            $('#searchInput').trigger('keyup');
        },
        error: function() {
            // Mostrar mensaje de error
            showMessage('alert-danger', 'Error al procesar el pago.');
        },
        complete: function() {
            // Restaurar el contenido del botón y habilitarlo nuevamente
            $boton.html('Realizar Pago').prop('disabled', false);
        }
    });
});

 
 
     // Función para la búsqueda
     function handleSearch(inputId, resultsId, searchUrl, idField) {
         $(inputId).on('keyup', function() {
             var search = $(this).val();
             $.ajax({
                 url: searchUrl,
                 type: 'POST',
                 data: { search: search },
                 success: function(response) {
                     $(resultsId).html(response).show();
                 }
             });
         });
 
         $(document).on('click', resultsId + ' div', function() {
             var value = $(this).text();
             var id = $(this).data('id');
             $(inputId).val(value);
             $('#' + idField).val(id);
             $(resultsId).hide();
         });
 
         $(document).on('click', function(event) {
             if (!$(event.target).closest(inputId).length && !$(event.target).closest(resultsId).length) {
                 $(resultsId).hide();
             }
         });
     }
 
     handleSearch('#addClienteInput', '#addClienteResults', 'search_clients.php', 'addClienteId');
     handleSearch('#addAutoInput', '#addAutoResults', 'search_autos.php', 'addAutoId');
     handleSearch('#editClienteInput', '#editClienteResults', 'search_clients.php', 'editClienteId');
     handleSearch('#editAutoInput', '#editAutoResults', 'search_autos.php', 'editAutoId');
 
     // Manejar la búsqueda en tiempo real
     $('#searchInput').on('keyup', function() {
         var search = $(this).val();
         $.ajax({
             url: 'search_renta.php',
             type: 'POST',
             data: { search: search },
             success: function(response) {
                 $('#rentaTableBody').html(response);
             }
         });
     });
 
     // Manejo de los días y precio total
     function getPrecioDiario(idAuto, callback) {
         $.ajax({
             url: 'get_auto_precio.php',
             type: 'POST',
             data: { id_habitacion: idAuto },
             dataType: 'json',
             success: function(response) {
                 if (response.status === 'success') {
                     callback(response.precio_diario);
                 } else {
                     alert('Error al obtener el precio de la Habitación.');
                 }
             }
         });
     }
 
     function calcularPrecioTotal() {
         var fechaRenta = new Date($('#addFechaRenta').val());
         var fechaDevolucion = new Date($('#addFechaDevolucion').val());
 
         if (fechaRenta && fechaDevolucion && $('#addAutoId').val()) {
             var diferencia = (fechaDevolucion - fechaRenta) / (1000 * 60 * 60 * 24); // Diferencia en días
             if (diferencia >= 0) {
                 $('#addDias').val(diferencia + ' días');
                 getPrecioDiario($('#addAutoId').val(), function(precioDiario) {
                     var precioTotal = diferencia * precioDiario;
                     $('#addPrecioTotal').val(precioTotal.toFixed(2));
                 });
             } else {
                 $('#addDias').val('');
                 $('#addPrecioTotal').val('');
             }
         } else {
             $('#addDias').val('');
             $('#addPrecioTotal').val('');
         }
     }
 
     $('#addFechaRenta, #addFechaDevolucion').on('change', calcularPrecioTotal);
     $('#addAutoInput').on('change', function() {
         var idAuto = $('#addAutoId').val();
         if (idAuto) {
             getPrecioDiario(idAuto, function(precioDiario) {
                 calcularPrecioTotal();
             });
         }
     });
 
     function calcularPrecioTotalEdit() {
        var fechaRenta = new Date($('#editFechaRenta').val());
        var fechaDevolucion = new Date($('#editFechaDevolucion').val());
    
        if (fechaRenta && fechaDevolucion && $('#editAutoId').val()) {
            var diferencia = (fechaDevolucion - fechaRenta) / (1000 * 60 * 60 * 24); // Diferencia en días
            if (diferencia >= 0) {
                $('#editDias').val(diferencia + ' días');
                getPrecioDiario($('#editAutoId').val(), function(precioDiario) {
                    var precioTotal = diferencia * precioDiario;
                    $('#editPrecioTotal').val(precioTotal.toFixed(2));
                });
            } else {
                $('#editDias').val('');
                $('#editPrecioTotal').val('');
            }
        } else {
            $('#editDias').val('');
            $('#editPrecioTotal').val('');
        }
    }
    
    $('#editFechaRenta, #editFechaDevolucion').on('change', calcularPrecioTotalEdit);
    $('#editAutoInput').on('change', function() {
        var idAuto = $('#editAutoId').val();
        if (idAuto) {
            getPrecioDiario(idAuto, function(precioDiario) {
                calcularPrecioTotalEdit();
            });
        }
    });
    
    // Manejar la edición de renta
$(document).on('click', '.edit-btn', function() {
    var id = $(this).data('id');
    $.ajax({
        url: 'get_renta.php',
        type: 'POST',
        data: { id_renta: id },
        dataType: 'json',
        success: function(response) {
            if (response.status === 'success') {
                var data = response.data;
                $('#editId').val(data.id_renta);
                
                // Obtener y mostrar el nombre del cliente
                getEntityName('clients', data.id_cliente, function(clientName) {
                    $('#editClienteInput').val(clientName);
                    $('#editClienteId').val(data.id_cliente);
                });
                
                // Obtener y mostrar el nombre del auto
                getEntityName('autos', data.id_auto, function(autoName) {
                    $('#editAutoInput').val(autoName);
                    $('#editAutoId').val(data.id_auto);
                    
                    // Llamar a calcularPrecioTotalEdit después de que se ha establecido el auto
                    calcularPrecioTotalEdit();
                });
                
                $('#editFechaRenta').val(data.fecha_renta);
                $('#editFechaDevolucion').val(data.fecha_devolucion);
                $('#editEstado').val(data.estado);
                
                $('#editModal').modal('show');
            } else {
                showMessage('alert-danger', 'Error al obtener datos de la renta.');
            }
        }
    });
});


$(document).ready(function() {
    $('#searchInputR').on('input', function() {
        // Obtén los valores del formulario
        var search = $('#searchInputR').val();
        var fechaInicio = $('#fechaInicio').val();
        var fechaFin = $('#fechaFin').val();

        // Realiza la solicitud AJAX
        $.ajax({
            url: 'buscar_rentas.php', // Cambia esto por la URL del archivo PHP que manejará la búsqueda
            type: 'POST',
            data: {
                search: search,
                fecha_inicio: fechaInicio,
                fecha_fin: fechaFin
            },
            success: function(response) {
                // Actualiza la tabla con la respuesta del servidor
                $('#rentaTableBody').html(response);
            },
            error: function() {
                alert('Hubo un error al procesar la solicitud.');
            }
        });
    });

    // Puedes agregar un evento de cambio en las fechas también si deseas
    $('#fechaInicio, #fechaFin').on('change', function() {
        // Obtén los valores del formulario
        var search = $('#searchInputR').val();
        var fechaInicio = $('#fechaInicio').val();
        var fechaFin = $('#fechaFin').val();

        // Realiza la solicitud AJAX
        $.ajax({
            url: 'buscar_rentas.php', // Cambia esto por la URL del archivo PHP que manejará la búsqueda
            type: 'POST',
            data: {
                search: search,
                fecha_inicio: fechaInicio,
                fecha_fin: fechaFin
            },
            success: function(response) {
                // Actualiza la tabla con la respuesta del servidor
                $('#rentaTableBody').html(response);
            },
            error: function() {
                alert('Hubo un error al procesar la solicitud.');
            }
        });
    });
});

 
     // Función para obtener el nombre de cliente o auto
     function getEntityName(type, id, callback) {
         $.ajax({
             url: 'get_entity_name.php',
             type: 'POST',
             data: { type: type, id: id },
             dataType: 'json',
             success: function(response) {
                 if (response.status === 'success') {
                     callback(response.name);
                 } else {
                     showMessage('alert-danger', 'Error al obtener el nombre.');
                 }
             }
         });
     }
 
     // Confirmar eliminación de renta
     $(document).on('click', '.delete-btn', function() {
         var rentaId = $(this).data('id');
         var confirmation = confirm('¿Estás seguro de que deseas eliminar esta renta?');
 
         if (confirmation) {
             $.ajax({
                 url: 'delete_renta.php',
                 type: 'POST',
                 data: { id_renta: rentaId },
                 success: function(response) {
                     if (response === 'success') {
                         showMessage('alert-success', 'Renta eliminada exitosamente.');
                         $('#searchInput').trigger('keyup');
                     } else {
                         showMessage('alert-danger', 'Error al eliminar la renta.');
                     }
                 }
             });
         }
     });
 
     // Manejar el envío del formulario de edición
     $('#editForm').on('submit', function(e) {
         e.preventDefault();
 
         $.ajax({
             url: 'update_renta.php',
             type: 'POST',
             data: $(this).serialize(),
             success: function(response) {
                 if (response === 'success') {
                     showMessage('alert-success', 'Renta actualizada exitosamente.');
                     $('#editModal').modal('hide');
                     $('#searchInput').trigger('keyup');
                 } else {
                     showMessage('alert-danger', 'Error al actualizar la renta.');
                 }
             }
         });
     });
 
     // Manejar el envío del formulario para agregar una renta
     $('#addForm').on('submit', function(e) {
         e.preventDefault();
 
         $.ajax({
             url: 'add_renta.php',
             type: 'POST',
             data: $(this).serialize(),
             success: function(response) {
                 if (response === 'success') {
                     showMessage('alert-success', 'Renta agregada exitosamente.');
                     $('#addModal').modal('hide');
                     // Limpia los campos del formulario
                     $('#addForm')[0].reset();
                     $('#searchInput').trigger('keyup');
                 } else {
                     showMessage('alert-danger', 'Error al agregar la renta.');
                 }
             }
         });
     });
 
     // Mostrar mensajes temporales
     function showMessage(type, text) {
         var message = $('#message');
         message.removeClass('d-none').removeClass('alert-success').removeClass('alert-danger');
         message.addClass(type).text(text);
 
         // Ocultar el mensaje después de 5 segundos
         setTimeout(function() {
             message.addClass('d-none');
         }, 5000);
     }
 
     // JavaScript para manejar el clic en el botón de filtro
     document.getElementById('filterTodayBtn').addEventListener('click', function() {
         document.getElementById('searchInput').value = 'fecha_devolucion_hoy';
         document.getElementById('searchForm').submit();
     });
 
     // Imprimir Contrato
     document.addEventListener('DOMContentLoaded', function() {
         const printButtons = document.querySelectorAll('.print-btn');
 
         printButtons.forEach(button => {
             button.addEventListener('click', function() {
                 const idRenta = this.getAttribute('data-id');
                 window.open('../reportes/print_contract.php?id_renta=' + idRenta, '_blank');
             });
         });
     });
     
 
 });