<?php
require('fpdf/fpdf.php'); // Incluir FPDF manualmente
require '../config.php'; // Conexión a la base de datos

// Obtener datos de la empresa
$sql = "SELECT * FROM empresa WHERE id_empresa = 1";
$stmt = $pdo->query($sql);
$empresa = $stmt->fetch(PDO::FETCH_ASSOC);

// Obtener filtros del formulario
$fechaInicio = $_GET['fechaInicio'] ?? '';
$fechaFin = $_GET['fechaFin'] ?? '';
$id_turno = $_GET['id_turno'] ?? '';
$id_usuario = $_GET['id_usuario'] ?? '';

// Construir la consulta SQL dinámicamente
$query = "SELECT v.id_venta, u.nombre_usuario, t.nombre AS turno, v.cliente, v.valor, v.ganancia, v.comision, v.numero, v.fecha 
          FROM ventas v
          JOIN usuarios u ON v.id_vendedor = u.id_usuario
          JOIN turnos t ON v.id_turno = t.id_turno
          WHERE 1 = 1";

$params = [];

if (!empty($fechaInicio) && !empty($fechaFin)) {
    $query .= " AND v.fecha BETWEEN :fechaInicio AND :fechaFin + INTERVAL 1 DAY - INTERVAL 1 SECOND";
    $params[':fechaInicio'] = $fechaInicio;
    $params[':fechaFin'] = $fechaFin;
}

if (!empty($id_turno)) {
    $query .= " AND v.id_turno = :id_turno";
    $params[':id_turno'] = $id_turno;
}

if (!empty($id_usuario)) {
    $query .= " AND v.id_vendedor = :id_usuario";
    $params[':id_usuario'] = $id_usuario;
}

$stmt = $pdo->prepare($query);
$stmt->execute($params);
$ventas = $stmt->fetchAll(PDO::FETCH_ASSOC);

// Inicializar los totales
$totalValor = 0;
$totalGanancia = 0;
$totalComision = 0;

// Calcular los totales
foreach ($ventas as $venta) {
    $totalValor += $venta['valor'];
    $totalGanancia += $venta['ganancia'];
    $totalComision += $venta['comision'];
}

// Crear el PDF
class PDF extends FPDF
{
    private $logo;

    // Constructor
    function __construct($logo)
    {
        parent::__construct();
        $this->logo = $logo; // Guardar logo
    }

    // Cabecera de página
    function Header()
    {
        // Logo a la izquierda
        if (!empty($this->logo)) {
            $this->Image('../img/' . $this->logo, 10, 10, 30); // Logo más pequeño a la izquierda
        }
        $this->Ln(20); // Salto de línea
        // Título
        $this->SetFont('Arial', 'B', 20); // Título más grande
        $this->SetTextColor(33, 37, 41); // Color oscuro
        $this->Cell(0, 10, 'Reporte de Ventas', 0, 1, 'C');
        $this->Ln(5); // Salto de línea para mejor separación

        // Línea separadora
        $this->SetDrawColor(0, 123, 255); // Color azul
        $this->Line(10, $this->GetY(), 200, $this->GetY()); // Línea horizontal
        $this->Ln(10); // Salto de línea
    }

    // Pie de página
    function Footer()
    {
        $this->SetY(-15); // Posición a 1.5 cm del final
        $this->SetFont('Arial', 'I', 8);
        $this->SetTextColor(33, 37, 41); // Color oscuro
        $this->Cell(0, 10, 'Página ' . $this->PageNo() . '/{nb}', 0, 0, 'C');
    }

    // Mostrar información del turno y vendedor
    function InfoTurnoVendedor($turno, $vendedor)
    {
        $this->SetFont('Arial', 'B', 16); // Texto más grande
        $this->SetTextColor(255, 255, 255); // Color blanco
        $this->SetFillColor(0, 123, 255); // Color azul
        $this->Cell(0, 12, "Turno: $turno", 0, 1, 'C', true);
        $this->Cell(0, 12, "Vendedor: $vendedor", 0, 1, 'C', true);
        $this->Ln(10); // Salto de línea
    }

    // Mostrar los totales en una línea
    function MostrarTotales($totalValor, $totalGanancia, $totalComision)
    {
        $this->SetFont('Arial', 'B', 16); // Texto más grande
        $this->SetTextColor(33, 37, 41); // Color oscuro
        $this->Cell(0, 10, 'Totales Generales', 0, 1, 'C');
        $this->Ln(10); // Salto de línea

        // Fondo para los totales
        $this->SetFillColor(233, 236, 239); // Color gris claro
        $this->SetFont('Arial', '', 14); // Texto más grande

        // Ancho de cada celda
        $anchoCelda = 60;

        // Total Valor
        $this->Cell($anchoCelda, 12, 'Total Valor: $' . number_format($totalValor, 2), 0, 0, 'C', true);

        // Total Ganancia
        $this->Cell($anchoCelda, 12, 'Total Premio: $' . number_format($totalGanancia, 2), 0, 0, 'C', true);

        // Total Comisión
        $this->Cell($anchoCelda, 12, 'Total Comision: $' . number_format($totalComision, 2), 0, 1, 'C', true);
    }

    // Tabla con datos de ventas
    function TablaVentas($ventas)
    {
        // Títulos de la tabla
        $this->SetFont('Arial', 'B', 12);
        $this->SetFillColor(0, 123, 255); // Color azul
        $this->SetTextColor(255, 255, 255); // Color blanco
        $this->Cell(30, 10, 'Numero', 1, 0, 'C', true);
        $this->Cell(30, 10, 'Valor', 1, 0, 'C', true);
        $this->Cell(30, 10, 'Premio', 1, 0, 'C', true);
        $this->Cell(30, 10, 'Comision', 1, 0, 'C', true);
        $this->Cell(60, 10, 'Fecha', 1, 1, 'C', true);

        // Datos de las ventas
        $this->SetFont('Arial', '', 12);
        $this->SetTextColor(33, 37, 41); // Color oscuro

        foreach ($ventas as $venta) {
            $this->Cell(30, 10, $venta['numero'], 1);
            $this->Cell(30, 10, '$' . number_format($venta['valor'], 2), 1);
            $this->Cell(30, 10, '$' . number_format($venta['ganancia'], 2), 1);
            $this->Cell(30, 10, '$' . number_format($venta['comision'], 2), 1);
            $this->Cell(60, 10, $venta['fecha'], 1, 1);
        }
    }
}

// Crear instancia de PDF y pasar el logo
$pdf = new PDF($empresa['logo']);
$pdf->AliasNbPages(); // Para el número de páginas
$pdf->AddPage(); // Añadir una página
$pdf->SetFont('Arial', '', 12);

// Obtener el nombre del turno y vendedor (si hay ventas)
$turno = !empty($ventas) ? $ventas[0]['turno'] : 'N/A';
$vendedor = !empty($ventas) ? $ventas[0]['nombre_usuario'] : 'N/A';

// Mostrar información del turno y vendedor
$pdf->InfoTurnoVendedor($turno, $vendedor);

// Mostrar los totales
$pdf->MostrarTotales($totalValor, $totalGanancia, $totalComision);

// Mostrar las ventas en tabla
$pdf->TablaVentas($ventas);

// Salida del PDF
$pdf->Output('I', 'Reporte_Ventas.pdf'); // 'I' para abrir en el navegador, 'D' para descargar
?>
