<?php
session_start();
require '../config.php';
require '../functions.php';

// Verificar si la caja está aperturada
if (!isCajaAperturada($pdo)) {
    header('Location: ../caja_no_aperturada.php');
    exit;
}

// Verifica si el usuario está autenticado
if (!isset($_SESSION['usuario_id'])) {
    header('Location: ../index.php');
    exit;
}

?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Historial de Sorteos</title>
    <link rel="shortcut icon" href="../img/favi.ico">
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
</head>
<body>
    <?php include '../menu.php'; ?>
    <div class="container mt-4">
    <div class="container mt-4">
        <div class="card shadow">
            <div class="card-header bg-primary text-white text-center">
                <h4><i class="fas fa-history"></i> Historial de Sorteos</h4>
            </div>
            <div class="card-body">
            <form id="filtro-form" class="mb-3">
    <div class="row">
        <div class="col-md-5">
            <label>Fecha Inicio:</label>
            <input type="date" id="fecha_inicio" class="form-control" value="<?= date('Y-m-d') ?>">
        </div>
        <div class="col-md-5">
            <label>Fecha Fin:</label>
            <input type="date" id="fecha_fin" class="form-control" value="<?= date('Y-m-d') ?>">
        </div>
        <div class="col-md-2 d-flex align-items-end">
            <button type="submit" class="btn btn-danger btn-block">
                <i class="fas fa-filter"></i> Filtrar
            </button>
        </div>
    </div>
</form>

<div class="table-responsive">
    <table class="table table-striped table-bordered mt-3 text-center">
        <thead class="table-dark">
            <tr>
                <th>Turno</th>
                <th>Número Ganador</th>
                <th>Fecha</th>
                <th>Usuario</th>
                <th>Detalles</th>
            </tr>
        </thead>
        <tbody id="historialSorteos">
            <!-- Aquí se cargarán los datos -->
        </tbody>
    </table>
</div>

<div id="mensaje" class="alert alert-warning text-center d-none">
    No hay sorteos registrados.
</div>
            </div>
        </div>
    </div>
    </div>

    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.9.2/dist/umd/popper.min.js"></script>
    <script src="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

    <script>
$(document).ready(function () {
    function cargarHistorial(fechaInicio, fechaFin) {
        $.ajax({
            url: "get_historial_sorteos.php",
            type: "GET",
            data: {
                fecha_inicio: fechaInicio,
                fecha_fin: fechaFin
            },
            dataType: "json",
            success: function (data) {
                let tbody = $("#historialSorteos");
                tbody.empty();

                if (data.length > 0) {
                    $("#mensaje").addClass("d-none");
                    $.each(data, function (index, sorteo) {
                        let fila = `
                            <tr>
                                <td>${sorteo.turno}</td>
                                <td>${sorteo.numero_ganador}</td>
                                <td>${sorteo.fecha}</td>
                                <td>${sorteo.usuario}</td>
                                <td>
                                    <a href="ver_detalle_sorteo.php?id_sorteo=${sorteo.id_sorteo}" class="btn btn-info">
                                        Ver Detalles
                                    </a>
                                </td>
                            </tr>
                        `;
                        tbody.append(fila);
                    });
                } else {
                    $("#mensaje").removeClass("d-none");
                }
            },
            error: function () {
                Swal.fire("Error", "No se pudo cargar el historial", "error");
            }
        });
    }

    // Al cargar la página, se filtran los datos por defecto con la fecha actual
    let hoy = new Date().toISOString().split("T")[0];
    cargarHistorial(hoy, hoy);

    // Filtro con el formulario
    $("#filtro-form").submit(function (e) {
        e.preventDefault();

        let fechaInicio = $("#fecha_inicio").val();
        let fechaFin = $("#fecha_fin").val();

        if (fechaInicio !== "" && fechaFin !== "") {
            cargarHistorial(fechaInicio, fechaFin);
        } else {
            Swal.fire("Atención", "Seleccione ambas fechas", "warning");
        }
    });
});
</script>
</body>
</html>
