<?php
session_start();
require '../config.php';

// Verificar si el usuario está autenticado
if (!isset($_SESSION['usuario_id'])) {
    header('Location: ../index.php');
    exit;
}

// Obtener los detalles del sorteo
$id_sorteo = $_GET['id_sorteo'] ?? null;
if ($id_sorteo === null) {
    echo "No se especificó un sorteo.";
    exit;
}

// Obtener los detalles del sorteo
$stmt = $pdo->prepare("SELECT hs.id_sorteo, t.nombre AS turno, hs.numero_ganador, hs.fecha, u.nombre AS usuario
                       FROM historial_sorteos hs
                       JOIN turnos t ON hs.id_turno = t.id_turno
                       JOIN usuarios u ON hs.usuario_id = u.id_usuario
                       WHERE hs.id_sorteo = ?");
$stmt->execute([$id_sorteo]);
$sorteo = $stmt->fetch(PDO::FETCH_ASSOC);

// Verificar si existe el sorteo
if (!$sorteo) {
    echo "Sorteo no encontrado.";
    exit;
}

// Obtener los detalles del sorteo agrupados por vendedor
$stmtDetalles = $pdo->prepare("SELECT vendedor, 
                                      SUM(valor_apostado) AS total_valor_apostado, 
                                      SUM(ganancia) AS total_ganancia, 
                                      SUM(monto_pagar) AS total_monto_pagar
                               FROM detalle_sorteos
                               WHERE id_sorteo = ?
                               GROUP BY vendedor");
$stmtDetalles->execute([$id_sorteo]);
$detalles = $stmtDetalles->fetchAll(PDO::FETCH_ASSOC);

// Inicializar totales
$totalValor = 0;
$totalGanancia = 0;
$totalMontoPagar = 0;
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Detalles del Sorteo</title>
    <link rel="shortcut icon" href="../img/favi.ico">
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
</head>
<body>
    <?php include '../menu.php'; ?>
    <div class="content">
    <div class="container mt-4">
        <div class="card shadow">
            <div class="card-header bg-primary text-white text-center">
                <h4><i class="fas fa-trophy"></i> Detalles del Sorteo</h4>
            </div>
            <div class="card-body">
                <h5><strong>Turno:</strong> <?php echo $sorteo['turno']; ?></h5>
                <h5><strong>Número Ganador:</strong> <?php echo $sorteo['numero_ganador']; ?></h5>
                <h5><strong>Fecha:</strong> <?php echo $sorteo['fecha']; ?></h5>
                <h5><strong>Usuario:</strong> <?php echo $sorteo['usuario']; ?></h5>

                <hr>
                <h4 class="text-center">Resultados</h4>
                <table class="table table-striped table-bordered mt-3 text-center">
                    <thead class="table-dark">
                        <tr>
                            <th>Vendedor</th>
                            <th>Valor Apostado</th>
                            <th>Premio</th>
                            <th>Monto a Pagar</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($detalles as $detalle) { 
                            // Acumular totales
                            $totalValor += $detalle['total_valor_apostado'];
                            $totalGanancia += $detalle['total_ganancia'];
                            $totalMontoPagar += $detalle['total_monto_pagar'];
                        ?>
                            <tr>
                                <td><?php echo $detalle['vendedor']; ?></td>
                                <td>$<?php echo number_format($detalle['total_valor_apostado'], 2); ?></td>
                                <td>$<?php echo number_format($detalle['total_ganancia'], 2); ?></td>
                                <td>$<?php echo number_format($detalle['total_monto_pagar'], 2); ?></td>
                            </tr>
                        <?php } ?>
                    </tbody>
                    <tfoot>
                        <tr class="table-warning">
                            <td><strong>TOTALES</strong></td>
                            <td><strong>$<?php echo number_format($totalValor, 2); ?></strong></td>
                            <td><strong>$<?php echo number_format($totalGanancia, 2); ?></strong></td>
                            <td><strong>$<?php echo number_format($totalMontoPagar, 2); ?></strong></td>
                        </tr>
                    </tfoot>
                </table>
            </div>
        </div>
    </div>
    </div>
</body>
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.11.6/dist/umd/popper.min.js"></script>
<script src="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>
</html>
