<?php
require '../config.php'; // Conexión a la base de datos

header('Content-Type: application/json');

try {
    // Obtener el correlativo de la última venta (última venta registrada)
    $query_correlativo = "SELECT correlativo FROM ventas ORDER BY id_venta DESC LIMIT 1";
    $stmt = $pdo->prepare($query_correlativo);
    $stmt->execute();
    $ultima_venta = $stmt->fetch(PDO::FETCH_ASSOC);

    if (!$ultima_venta) {
        echo json_encode(['status' => 'error', 'message' => 'No hay ventas registradas.']);
        exit;
    }

    $correlativo = $ultima_venta['correlativo'];

    // Obtener todas las ventas con el mismo correlativo
    $query_ventas = "SELECT 
                        v.id_venta, 
                        t.nombre AS nombre_turno, 
                        v.numero, 
                        v.cliente, 
                        v.valor, 
                        v.ganancia, 
                        v.fecha, 
                        u.nombre AS nombre_vendedor
                    FROM ventas v
                    JOIN turnos t ON v.id_turno = t.id_turno
                    JOIN usuarios u ON v.id_vendedor = u.id_usuario
                    WHERE v.correlativo = ?  -- Buscar todas las ventas con el mismo correlativo
                    ORDER BY v.id_venta DESC";

    $stmt = $pdo->prepare($query_ventas);
    $stmt->execute([$correlativo]);
    $ventas = $stmt->fetchAll(PDO::FETCH_ASSOC);

    if ($ventas) {
        echo json_encode(['status' => 'success', 'ventas' => $ventas, 'correlativo' => $correlativo]);
    } else {
        echo json_encode(['status' => 'error', 'message' => 'No se encontraron ventas con el mismo correlativo.']);
    }
} catch (PDOException $e) {
    echo json_encode(['status' => 'error', 'message' => 'Error en la base de datos.']);
}
?>
