<?php
session_start();
require '../config.php';
require '../functions.php';

// Verificar si la caja está aperturada
if (!isCajaAperturada($pdo)) {
    header('Location: ../caja_no_aperturada.php');
    exit;
}

// Verifica si el usuario está autenticado
if (!isset($_SESSION['usuario_id'])) {
    header('Location: ../index.php');
    exit;
}
// Verifica si el usuario tiene permiso para acceder a la página
if (!usuarioTienePermiso($pdo, $_SESSION['usuario_id'], 'ver_ventas')) {
    header('Location: ../sin_permiso.php');
    exit;
}
// Verifica los permisos del usuario para ver, editar y eliminar
$usuario_id = $_SESSION['usuario_id'];
$fifa = $_SESSION['rifa'];
$comision = $_SESSION['comision'];

$permisos = [
    'ver' => usuarioTienePermiso($pdo, $usuario_id, 'ver_ventas'),
    'editar' => usuarioTienePermiso($pdo, $usuario_id, 'editar_ventas'),
    'eliminar' => usuarioTienePermiso($pdo, $usuario_id, 'borrar_ventas'),
];

// Obtener la hora de finalización del turno actual
date_default_timezone_set('America/El_Salvador');
$hora_actual = date('H:i:s');
$sql = "SELECT id_turno, nombre, hora_inicio, hora_fin FROM turnos ORDER BY hora_fin ASC";
$stmt = $pdo->query($sql);
$turnos = $stmt->fetchAll(PDO::FETCH_ASSOC);

$turno_activo_id = null;
$hora_fin_turno = null;

foreach ($turnos as $turno) {
    if ($hora_actual <= $turno['hora_fin']) {
        $turno_activo_id = $turno['id_turno'];
        $hora_fin_turno = $turno['hora_fin'];
        break;
    }
}

if ($turno_activo_id === null && !empty($turnos)) {
    $turno_activo_id = $turnos[0]['id_turno'];
    $hora_fin_turno = $turnos[0]['hora_fin'];
}

?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Vendedor</title>
    <link rel="shortcut icon" href="../img/favi.ico">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>

    <link href="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css" rel="stylesheet">
    
    <style>
        /* Asegura que el cuerpo y el HTML se ajusten correctamente */
        body, html {
            height: 100%;
            margin: 0;
        }

        /* Asegura que la página ocupe el 100% del ancho y alto */
        .container-fluid {
            height: 100%;
        }
        .main-content {
            padding: 2rem;
        }

        .input-group {
            width: 100%;
            max-width: 500px;
        }

        .input-group-append .btn-secondary {
            border-radius: 0 50px 50px 0;
        }

        .btn-info {
            border-radius: 50px;
            font-size: 0.875rem;
            box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1);
        }

        #message {
            position: fixed;
            top: 10px;
            right: 10px;
            width: 300px;
            z-index: 1050; /* Asegúrate de que esté encima de otros elementos */
        }

        @media (max-width: 767px) {
    .btn .fas {
        font-size: 1.5rem;  /* Aumenta el tamaño del icono en pantallas pequeñas */
    }
}


        .modal-content {
            padding: 20px;
        }

        #numerosDisponibles {
    display: grid;
    grid-template-columns: repeat(auto-fill, minmax(70px, 1fr)); /* Distribuye los números de manera responsiva */
    gap: 10px;
    margin-top: 20px;
}

.badge {
    font-size: 18px;
    padding: 10px 20px;
    border-radius: 25px;
    text-align: center;
    transition: transform 0.3s ease, background-color 0.3s ease; /* Transición suave para el hover */
    cursor: pointer;
}

.badge:hover {
    transform: scale(1.1); /* Aumenta el tamaño cuando se pasa el cursor */
}

.bg-success {
    background-color: #28a745; /* Verde para disponibles */
    color: white;
}

.bg-danger {
    background-color: #dc3545; /* Rojo para vendidos */
    color: white;
}

.bg-success:hover {
    background-color: #218838; /* Verde más oscuro en hover */
}

.bg-danger:hover {
    background-color: #c82333; /* Rojo más oscuro en hover */
}

.badge[style*="cursor: not-allowed;"] {
    cursor: not-allowed; /* Cursor no permitido para números vendidos */
    opacity: 0.5; /* Reduce la opacidad para los números no seleccionables */
}

.badge:active {
    transform: scale(1); /* Evita que el número se agrande cuando se hace clic */
}
#numerosDisponibles .numero-card {
        display: flex;
        align-items: center;
        justify-content: center;
        width: 80px;
        height: 80px;
        font-size: 1.2rem;
        font-weight: bold;
        color: white;
        background: linear-gradient(135deg, #007bff, #0056b3);
        border-radius: 10px;
        cursor: pointer;
        transition: transform 0.2s, box-shadow 0.2s;
    }

    #numerosDisponibles .numero-card:hover {
        transform: scale(1.1);
        box-shadow: 0px 4px 10px rgba(0, 0, 0, 0.2);
    }
    </style>
</head>
<body>
    <!-- Barra de navegación con Bootstrap -->
    <nav class="navbar navbar-expand-lg navbar-dark bg-dark">
        <a class="navbar-brand" href="#">
            <i class="fas fa-chart-line"></i> (Bienvenido, <?php echo htmlspecialchars($_SESSION['usuario']); ?> !)
        </a>
        <button class="navbar-toggler" type="button" data-toggle="collapse" data-target="#navbarNav" aria-controls="navbarNav" aria-expanded="false" aria-label="Toggle navigation">
            <span class="navbar-toggler-icon"></span>
        </button>
        <div class="collapse navbar-collapse" id="navbarNav">
            <ul class="navbar-nav ml-auto">
                <?php if (isset($_SESSION['rol']) && $_SESSION['rol'] === 'admin') : ?>
    <li class="nav-item">
        <a class="nav-link text-white" href="../dashboard/dashboard.php">
            <i class="fas fa-tachometer-alt"></i> Administración
        </a>
    </li>
<?php endif; ?>
                <li class="nav-item">
                    <a class="nav-link text-white" href="../logout.php"><i class="fas fa-sign-out-alt"></i> Cerrar sesión</a>
                </li>
            </ul>
        </div>
    </nav>

    <!-- Contenido principal -->
         <!-- Contador de tiempo restante -->
         <div class="text-center mt-3">
                <p> Cierre del sorteo:
                    <span id="contador-tiempo" class="badge"></span>
                </p>
            </div>
        <div class="container mt-4">
       <!--  <div class="container-fluid">-->
            <!-- Formulario para vender números -->
            <div style=" background-color:#f4f6f6; border-radius: 5px; border: 1px" class="card p-3">
            <h4 style="text-align: center;">Registrar Venta</h4>
                <form id="formVenta">
                    <div class="row mb-3">
                        <div class="col-md-6">
                            <label for="id_turno">Seleccionar Sorteo:</label>
                            <select id="id_turno" name="id_turno" class="form-control" required>
                            <?php
date_default_timezone_set('America/El_Salvador'); // Ajusta la zona horaria según tu ubicación
$hora_actual = date('H:i:s');

// Obtener el día actual (0 = domingo, 1 = lunes, ..., 6 = sábado)
$dia_actual = date('w');

// Construir la consulta SQL según el día
if ($dia_actual == 0) { // Domingo
    $sql = "SELECT id_turno, nombre, hora_inicio, hora_fin, dia 
            FROM turnos 
            WHERE dia = 'domingo' 
            ORDER BY hora_fin ASC";
} else { // Lunes a Sábado
    $sql = "SELECT id_turno, nombre, hora_inicio, hora_fin, dia 
            FROM turnos 
            WHERE dia = 'semana' 
            ORDER BY hora_fin ASC";
}

$stmt = $pdo->query($sql);
$turnos = $stmt->fetchAll(PDO::FETCH_ASSOC);

$turno_activo_id = null;

// Determinar qué turno debe estar seleccionado por defecto
foreach ($turnos as $turno) {
    if ($hora_actual >= $turno['hora_inicio'] && $hora_actual <= $turno['hora_fin']) {
        $turno_activo_id = $turno['id_turno'];
        break;
    }
}

// Si no hay turnos activos, mostrar "Turnos desactivados"
if ($turno_activo_id === null) {
    echo "<option value=''>Turnos desactivados</option>";
} else {
    // Generar las opciones del select
    foreach ($turnos as $turno) {
        $selected = ($turno['id_turno'] == $turno_activo_id) ? 'selected' : '';
        echo "<option value='{$turno['id_turno']}' $selected>{$turno['nombre']}</option>";
    }
}
?>

                            </select>

                        </div>
                        <div class="col-md-6">
                            <label for="cliente">Nombre del Cliente:</label>
                            <input type="text" id="cliente" name="cliente" class="form-control" required autocomplete="off">
                            <div id="sugerencias" class="list-group" style="position: absolute; z-index: 1000;"></div>
                        </div>
                    </div>

                    <div class="row mb-3">
                    <div class="col-md-6">
                        <label for="numero">Número a vender (00 - 99):</label>
                        <div class="input-group"> <!-- Usamos input-group para agrupar el input y el botón -->
                            <input type="number" id="numero" name="numero" min="0" max="99" class="form-control" required>
                            <button type="button" class="btn btn-info" id="verDisponibles" data-bs-toggle="modal" data-bs-target="#modalNumeros">
                                Ver Números
                            </button>
                        </div>
                        <span id="mensaje" class="mt-2 d-block"></span> <!-- Mensaje debajo del input -->
                    </div>
                       

                    <div class="col-md-6">
    <label for="valor">Valor de la Apuesta ($):</label>
    <input type="text" id="valor" name="valor" class="form-control" required placeholder="0.25, 0.50, 0.75, 1.00, ...">
    <small id="errorValor" style="color: red; display: none;">❌ Número incorrecto. Debe ser múltiplo de 0.25</small>
</div>

<script>
document.getElementById("valor").addEventListener("blur", function () {
    let valor = this.value.trim();
    let errorMsg = document.getElementById("errorValor");

    // Permitir el 0 inicial y convertir el valor a número
    if (valor === "" || isNaN(valor)) {
        this.value = ""; // Si el campo está vacío o no es un número, borrarlo
        errorMsg.style.display = "block";
        return;
    }

    let numero = parseFloat(valor);
    
    // Validar que sea múltiplo de 0.25
    if (numero < 0.25 || (numero * 100) % 25 !== 0) {
        this.value = ""; // Borrar si no es válido
        errorMsg.style.display = "block"; // Mostrar mensaje de error
    } else {
        errorMsg.style.display = "none"; // Ocultar mensaje si es válido
    }
});
</script>

                    </div>

                   
    

                    <div class="d-flex justify-content-center">
                          <!-- Botón para agregar al carrito -->
                        <button type="button" class="btn btn-warning d-flex align-items-center justify-content-center mr-2" id="agregarCarrito">
                            <i class="fas fa-cart-plus mr-2"></i>
                            Agregar numero
                        </button>       
                    </div>
                </form>
            </div>

            <!-- Tabla para mostrar los números agregados -->
                <div class="card mt-3 p-3">
                    <h5 style="text-align: center;">Carrito de Números</h5>
                    <div class="table-responsive">
                    <table class="table table-striped table-bordered mt-3">
                        <thead class="thead-dark">
                            <tr>
                                <th>Número</th>
                                <th>Cliente</th>
                                <th>Valor</th>
                                <th></th>
                            </tr>
                        </thead>
                        <tbody id="tablaCarrito">
                            <!-- Aquí se cargarán los números con AJAX -->
                        </tbody>
                    </table>
                </div>
                <div class="d-flex justify-content-center">
                        <!-- Botón para vender -->
                        <button type="button" class="btn btn-danger d-flex align-items-center justify-content-center mr-2" id="venderButton">
                            <i class="fas fa-dollar-sign mr-2"></i>
                            Vender
                        </button>

                        <!-- Botón para imprimir el ticket -->
                        <button id="imprimirUltimaVenta" class="btn btn-primary" style="display:none;">
                            Imprimir Ticket
                        </button>
                    </div>
                </div>

               
        
            <!-- Sección para mostrar ventas -->
            <div class="row text-center mt-4">
                <div class="col-md-4 mb-3">
                    <div class="p-3 rounded bg-info text-white">
                        <h4>Total Vendido:</h4>
                        <span id="totalVentas" class="h3">$0.00</span>
                    </div>
                </div>
                <div class="col-md-4 mb-3">
                    <div class="p-3 rounded bg-danger text-white">
                        <h4>Comisión (<?php echo $_SESSION['comision']; ?>%):</h4>
                        <span id="comision" class="h3">$0.00</span>
                    </div>
                </div>
                <div class="col-md-4 mb-3">
                    <div class="p-3 rounded bg-success text-white">
                        <h4>Entregar:</h4>
                        <span id="entregar" class="h3">$0.00</span>
                    </div>
                </div>
            </div>

            <div class="table-responsive">
    <table class="table table-striped table-bordered mt-3" id="tablaVentas">
        <thead class="thead-dark">
            <tr>
                <th>Sorteo</th>
                <th>Número</th>
                <th>Cliente</th>
                <th>Valor</th>
                <th>Ganancia</th>
                <th>Fecha</th>
            </tr>
        </thead>
        <tbody>
            <!-- Aquí van los datos de la tabla -->
        </tbody>
    </table>
</div>
        </div>

    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.11.6/dist/umd/popper.min.js"></script>
    <script src="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <!-- Incluye SweetAlert2 desde un CDN -->
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <script src="ventas.js"></script>
    <script src="ultima_venta.js"></script>

<!-- Modal Mejorado -->
<div class="modal fade" id="modalNumeros" tabindex="-1" aria-labelledby="modalNumerosLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header bg-primary text-white">
                <h5 class="modal-title" id="modalNumerosLabel">Números Disponibles</h5>
                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <div id="numerosDisponibles" class="d-flex flex-wrap gap-3 p-2 justify-content-center" 
                     style="max-height: 400px; overflow-y: auto;">
                </div>
            </div>
        </div>
    </div>
</div>
   
<script>
$(document).ready(function () {

       // Función para actualizar el contador de tiempo restante
       function actualizarContador() {
            let horaFinTurno = "<?php echo $hora_fin_turno; ?>"; // Hora de finalización del turno
            let ahora = new Date(); // Hora actual
            let finTurno = new Date(ahora.toDateString() + " " + horaFinTurno); // Convertir a objeto Date

            // Obtener el elemento del contador
            let contador = document.getElementById("contador-tiempo");

            // Verificar si el turno ha finalizado
            if (ahora > finTurno) {
                contador.innerText = "El Sorteo ha finalizado";
                contador.classList.remove("badge-success"); // Quitar clase verde
                contador.classList.add("badge-danger"); // Agregar clase roja
                return;
            }

            // Calcular la diferencia de tiempo
            let diferencia = finTurno - ahora;
            let horas = Math.floor(diferencia / (1000 * 60 * 60));
            let minutos = Math.floor((diferencia % (1000 * 60 * 60)) / (1000 * 60));
            let segundos = Math.floor((diferencia % (1000 * 60)) / 1000);

            // Formatear el tiempo restante
            let tiempoRestante = 
                `${horas.toString().padStart(2, '0')}:${minutos.toString().padStart(2, '0')}:${segundos.toString().padStart(2, '0')}`;

            // Actualizar el texto y el estilo
            contador.innerText = tiempoRestante;
            contador.classList.remove("badge-danger"); // Quitar clase roja
            contador.classList.add("badge-success"); // Agregar clase verde
        }

        // Actualizar el contador cada segundo
        setInterval(actualizarContador, 1000);
        actualizarContador(); // Llamar inmediatamente para evitar el retraso inicial

    // Al hacer clic en el botón "Ver Números Disponibles"
    $("#verDisponibles").click(function () {
        let id_turno = $("#id_turno").val(); // Obtener el turno seleccionado

        $.ajax({
            url: "obtener_numeros.php",
            type: "POST",
            data: { id_turno: id_turno },
            dataType: "json",
            success: function (response) {
                let container = $("#numerosDisponibles");
                container.html(""); // Limpiar antes de agregar nuevos datos

                if (response.status === "success") {
                    // Si el turno ha vencido, mostrar alerta y bloquear selección
                    if (response.turno_vencido) {
                        Swal.fire({
                            icon: 'error',
                            title: 'El turno ha vencido.',
                            text: 'No puedes seleccionar números en un turno vencido.',
                            showConfirmButton: false,
                            timer: 2000
                        });
                        return; // Detener ejecución
                    }

                    // Generar los números disponibles
                    response.numeros.forEach(numero => {
                        let color = numero.vendido ? "danger" : "success";
                        let estado = numero.vendido ? "V" : "D";

                        let item = `<span class="badge bg-${color} m-1 p-3" 
                            style="cursor: ${numero.vendido ? 'not-allowed' : 'pointer'};" 
                            onclick="seleccionarNumero(${numero.numero}, ${numero.vendido})">
                            ${numero.numero} - ${estado}
                        </span>`;

                        container.append(item);
                    });
                } else {
                    container.html(`<div class="alert alert-warning">${response.message}</div>`);
                }
            },
            error: function () {
                $("#numerosDisponibles").html('<div class="alert alert-danger">Error al cargar los números.</div>');
            }
        });
    });

    // Función para seleccionar un número, solo si no está vendido
    window.seleccionarNumero = function(numero, vendido) {
        if (vendido) {
            Swal.fire({
                icon: 'error',
                title: 'Este número ya ha sido vendido.',
                text: 'No se puede seleccionar un número vendido.',
                showConfirmButton: false,
                timer: 1500
            });
        } else {
            $('#numero').val(numero); // Agregar el número al input del formulario
            $('#modalNumeros').modal('hide'); // Cerrar la modal después de seleccionar
        }
    };

    $("#cliente").on("input", function () {
        let nombre = $(this).val().trim();

        if (nombre.length > 1) {
            $.ajax({
                url: "buscar_cliente.php",
                type: "POST",
                data: { cliente: nombre },
                success: function (response) {
                    $("#sugerencias").html(response).show();
                },
            });
        } else {
            $("#sugerencias").hide();
        }
    });

    // Cuando se haga clic en una sugerencia, se rellena el input
    $(document).on("click", ".sugerencia-cliente", function () {
        $("#cliente").val($(this).text());
        $("#sugerencias").hide();
    });

    // Ocultar sugerencias si se hace clic fuera
    $(document).click(function (e) {
        if (!$(e.target).closest("#cliente, #sugerencias").length) {
            $("#sugerencias").hide();
        }
    });

});

</script>
</body>
</html>
