<?php
session_start();
require 'config.php';
require 'functions.php';

if (!isset($_SESSION['usuario_id'])) {
    header('Location: ../index.php');
    exit;
}

// Procesar la solicitud de apertura de caja
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $monto = $_POST['monto'];
    $usuario_id = $_SESSION['usuario_id'];

    $sql = "INSERT INTO caja (tipo, monto, fecha, usuario_id) VALUES ('apertura', :monto, NOW(), :usuario_id)";
    $stmt = $pdo->prepare($sql);
    if ($stmt->execute(['monto' => $monto, 'usuario_id' => $usuario_id])) {
        header('Location: index.php');
        exit;
    } else {
        echo "Error al abrir la caja.";
    }
}
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Apertura de Caja</title>
    <link href="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css" rel="stylesheet">
</head>
<body>
    <div class="container">
        <h1>Apertura de Caja</h1>
        <form action="apertura_caja.php" method="POST">
            <div class="form-group">
                <label for="monto">Monto de Apertura</label>
                <input type="number" id="monto" name="monto" class="form-control" step="0.01" required>
            </div>
            <button type="submit" class="btn btn-primary">Abrir Caja</button>
        </form>
    </div>
</body>
</html>
