<?php
// Verificar si se ha enviado el ID del archivo a eliminar
if (isset($_POST['id'])) {
    session_start();
    require '../config.php'; // Asegúrate de que en config.php esté configurada la conexión PDO
    require '../functions.php'; // Incluye cualquier función adicional que necesites

    // Obtener el ID del archivo a eliminar
    $id_archivo = $_POST['id'];

    try {
        // Consulta SQL para eliminar el archivo de la base de datos
        $query = "DELETE FROM archivos WHERE id = :id_archivo";
        $stmt = $pdo->prepare($query);
        $stmt->bindParam(':id_archivo', $id_archivo, PDO::PARAM_INT);

        // Ejecutar la consulta
        if ($stmt->execute()) {
            // Si la eliminación fue exitosa, devolver "success" como respuesta
            echo "success";
        } else {
            // Si hubo un error, devolver un mensaje de error como respuesta
            echo "error";
        }
    } catch (PDOException $e) {
        // Si ocurre un error en la base de datos, devolver un mensaje de error
        echo "error: " . $e->getMessage();
    }

    // Cerrar la conexión (PDO no tiene un método close(), simplemente establece la variable a null)
    $pdo = null;
} else {
    // Si no se proporcionó el ID del archivo a eliminar, devolver un mensaje de error como respuesta
    echo "error";
}
?>
