$(document).ready(function(){
    // Cargar lista de archivos al cargar la página
    cargarListaArchivos();
 // Función para filtrar la lista de archivos
 function filtrarArchivos() {
    var nombre = $('#busquedaNombre').val();
    var estudios = $('#busquedaEstudios').val();

    $.ajax({
        url: 'filtrar_archivos.php',
        type: 'POST',
        data: { nombre: nombre, estudios: estudios },
        success: function(data) {
            $('#tablaArchivos tbody').html(data);
        }
    });
}

// Ejecutar la función de filtrado al cambiar el valor de los campos de búsqueda
$('#busquedaNombre, #busquedaEstudios').on('input', function() {
    filtrarArchivos();
});
$('#formulario').submit(function(e){
    e.preventDefault();
    var formData = new FormData(this);

    // Deshabilitar el botón de enviar y mostrar mensaje de "Cargando..."
    var $boton = $('#submitButton'); // Asume que tienes un botón con ID 'submitButton'
    $boton.prop('disabled', true);
    $boton.text('Subiendo...'); // Cambiar el texto del botón

    $.ajax({
        url: 'upload_archivo.php',
        type: 'POST',
        data: formData,
        contentType: false,
        processData: false,
        success: function(response){
            // Mostrar una alerta con SweetAlert2 basada en la respuesta
            if (response.includes('correctamente')) {
                Swal.fire({
                    icon: 'success',
                    title: '¡Éxito!',
                    text: 'El archivo se ha subido correctamente.',
                    confirmButtonText: 'Aceptar',
                    confirmButtonColor: '#3085d6',
                    background: '#f9f9f9'
                });
            } else {
                Swal.fire({
                    icon: 'error',
                    title: 'Error',
                    text: response,
                    confirmButtonText: 'Aceptar',
                    confirmButtonColor: '#d33',
                    background: '#f9f9f9'
                });
            }

            // Cerrar el modal y actualizar la lista de archivos si la subida fue exitosa
            $('#myModal').modal('hide');
            cargarListaArchivos();

            // Rehabilitar el botón y restaurar el texto original
            $boton.prop('disabled', false);
            $boton.text('Enviar Archivo'); // Restaurar el texto original
        },
        error: function() {
            // Mostrar alerta de error si hay un problema con la solicitud AJAX
            Swal.fire({
                icon: 'error',
                title: 'Error',
                text: 'Hubo un problema al intentar subir el archivo.',
                confirmButtonText: 'Aceptar',
                confirmButtonColor: '#d33',
                background: '#f9f9f9'
            });

            // Rehabilitar el botón incluso si hay un error
            $boton.prop('disabled', false);
            $boton.text('Enviar Archivo'); // Restaurar el texto original
        }
    });
});


    function cargarListaArchivos() {
        $.ajax({
            url: 'get_archivos.php',
            success: function(data){
                $('#archivos-lista').html(data);
            }
        });
    } // Aquí cerramos la función cargarListaArchivos
}); // Aquí cerramos $(document).ready

function eliminarArchivo(id) {
    // Usar SweetAlert2 para confirmar la eliminación
    Swal.fire({
        title: '¿Estás seguro?',
        text: "No podrás revertir esto.",
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#3085d6',
        cancelButtonColor: '#d33',
        confirmButtonText: 'Sí, eliminarlo',
        cancelButtonText: 'Cancelar',
        background: '#f9f9f9'
    }).then((result) => {
        if (result.isConfirmed) {
            // Realizar la solicitud AJAX para eliminar el archivo
            $.ajax({
                url: 'delete_archivo.php',
                type: 'POST',
                data: { id: id },
                success: function(response) {
                    // Verificar si la eliminación fue exitosa
                    if (response === 'success') {
                        // Mostrar mensaje de éxito con SweetAlert2
                        Swal.fire({
                            icon: 'success',
                            title: '¡Eliminado!',
                            text: 'El archivo se eliminó correctamente.',
                            confirmButtonColor: '#3085d6',
                            background: '#f9f9f9'
                        });
                        // Actualizar la lista de archivos
                        cargarListaArchivos2();
                    } else {
                        // Mostrar mensaje de error con SweetAlert2
                        Swal.fire({
                            icon: 'error',
                            title: 'Error',
                            text: 'Hubo un error al eliminar el archivo.',
                            confirmButtonColor: '#d33',
                            background: '#f9f9f9'
                        });
                    }
                },
                error: function() {
                    // Mostrar mensaje de error con SweetAlert2
                    Swal.fire({
                        icon: 'error',
                        title: 'Error',
                        text: 'Hubo un error en la solicitud.',
                        confirmButtonColor: '#d33',
                        background: '#f9f9f9'
                    });
                }
            });
        }
    });


    function cargarListaArchivos2() {
        $.ajax({
            url: 'get_archivos.php',
            success: function(data){
                $('#archivos-lista').html(data);
            }
        });
    } // Aquí cerramos la función cargarListaArchivos
}

