$(document).ready(function() {
    function loadTable(page = 1) {
        $.ajax({
            url: 'crud_caja.php',
            type: 'POST',
            data: { page: page }, // Enviar el número de página actual
            success: function(response) {
                $('#cashTableBody').html($(response).find('#cashTableBody').html());
            }
        });
    }

    // Filtrar por fechas, tipo y búsqueda general
$('#filterBtn').on('click', function() {
    var startDate = $('#startDate').val();
    var endDate = $('#endDate').val();
    var search = $('#searchInput').val();  // Obtener el valor de búsqueda
    var type = $('#type').val();  // Obtener el valor del tipo seleccionado

    $.ajax({
        url: 'search_caja.php',
        type: 'POST',
        data: { 
            startDate: startDate,
            endDate: endDate,
            search: search,  // Incluir el valor de búsqueda
            type: type  // Incluir el tipo
        },
        success: function(response) {
            $('#cashTableBody').html(response);
        }
    });
});;

    $(document).on('click', '.edit-btn', function() {
        var id = $(this).data('id');
        $.ajax({
            url: 'get_cash.php',
            type: 'POST',
            data: { id_caja: id },
            dataType: 'json',
            success: function(response) {
                if (response.status === 'success') {
                    var data = response.data;
                    $('#editId').val(data.id_caja);
                    $('#editTipo').val(data.tipo);
                    $('#editMonto').val(data.monto);
                    $('#editModal').modal('show');
                } else {
                    showMessage('alert-danger', 'Error al obtener datos.');
                }
            }
        });
    });

    $(document).on('click', '.delete-btn', function() {
        var id = $(this).data('id');
        var confirmation = confirm('¿Estás seguro de que deseas eliminar este registro?');

        if (confirmation) {
            $.ajax({
                url: 'delete_cash.php',
                type: 'POST',
                data: { id_caja: id },
                success: function(response) {
                    if (response === 'success') {
                        showMessage('alert-success', 'Registro eliminado exitosamente.');
                        $('#searchInput').trigger('keyup');
                    } else {
                        showMessage('alert-danger', 'Error al eliminar el registro.');
                    }
                }
            });
        }
    });

    $('#editForm').on('submit', function(e) {
        e.preventDefault();
        $.ajax({
            url: 'edit_cash.php',
            type: 'POST',
            data: $(this).serialize(),
            success: function(response) {
                if (response === 'success') {
                    showMessage('alert-success', 'Registro actualizado exitosamente.');
                    $('#editModal').modal('hide');
                    //$('#searchInput').trigger('keyup');
                    loadTable(); // Actualizar la tabla
                } else {
                    showMessage('alert-danger', 'Error al actualizar el registro.');
                }
            }
        });
    });

    $('#addForm').on('submit', function(e) {
        e.preventDefault();
        $.ajax({
            url: 'add_cash.php',
            type: 'POST',
            data: $(this).serialize(),
            success: function(response) {
                if (response === 'success') {
                    showMessage('alert-success', 'Registro agregado exitosamente.');
                    $('#addModal').modal('hide');
                    $('#addForm')[0].reset();
                    //$('#searchInput').trigger('keyup');
                    loadTable(); // Actualizar la tabla
                } else {
                    showMessage('alert-danger', 'Error al agregar el registro.');
                }
            }
        });
    });

    function showMessage(type, text) {
        var message = $('#message');
        message.removeClass('d-none').removeClass('alert-success').removeClass('alert-danger');
        message.addClass(type).text(text);

        setTimeout(function() {
            message.addClass('d-none');
        }, 5000);
    }
    $(document).on('click', '.reprint-btn', function() {
        var idCaja = $(this).data('id'); // Obtiene el ID del corte de caja
    
        // Realiza la solicitud AJAX para obtener el ticket en HTML
        $.ajax({
            url: 'print_ticket.php', // Ruta del script PHP que genera el ticket
            type: 'GET',
            data: { id_caja: idCaja }, // Envía el ID del corte de caja como parámetro
            success: function(response) {
                // Abre una nueva ventana para el ticket
                var mywindow = window.open('', 'Ticket de Corte de Caja', 'height=800,width=800');
                mywindow.document.write(response); // Escribe el contenido del ticket en la ventana
                mywindow.document.close(); // Necesario para IE >= 10
                mywindow.focus(); // Necesario para IE >= 10
                mywindow.print(); // Abre la ventana de impresión
                mywindow.close(); // Cierra la ventana después de imprimir
            },
            error: function() {
                alert('Error al generar el ticket.'); // Maneja errores si la solicitud falla
            }
        });
    });
    


    
});