<?php
session_start();
require '../config.php';
require '../functions.php';

if (!isset($_SESSION['usuario_id'])) {
    header('Location: ../index.php');
    exit;
}
function getCajas($pdo, $search = '', $offset = 0, $limit = 10) {
    $sql = "SELECT caja.*, usuarios.nombre, usuarios.apellido 
            FROM caja 
            JOIN usuarios ON caja.usuario_id = usuarios.id_usuario 
            WHERE caja.tipo LIKE :search
            ORDER BY caja.id_caja DESC
            LIMIT :offset, :limit";
    $stmt = $pdo->prepare($sql);
    $stmt->bindValue(':search', "%$search%", PDO::PARAM_STR);
    $stmt->bindValue(':offset', (int)$offset, PDO::PARAM_INT);
    $stmt->bindValue(':limit', (int)$limit, PDO::PARAM_INT);
    $stmt->execute();
    return $stmt->fetchAll(PDO::FETCH_ASSOC);
}

$search = isset($_POST['search']) ? $_POST['search'] : '';
$page = isset($_POST['page']) ? (int)$_POST['page'] : 1;
$limit = 10;
$offset = ($page - 1) * $limit;

$cajas = getCajas($pdo, $search, $offset, $limit);
foreach ($cajas as $caja) {
    // Definir el badge basado en el tipo de caja
    $badgeClass = $caja['tipo'] == 'apertura' ? 'badge-success' : 'badge-danger';
    $badgeText = $caja['tipo'] == 'apertura' ? 'Apertura' : 'Cierre';
    
    echo "<tr>
        <td>{$caja['id_caja']}</td>
        <td><span class='badge {$badgeClass}'>{$badgeText}</span></td>
        <td>" . formatMonto($moneda, $caja['monto']) . "</td>
        <td>{$caja['fecha']}</td>
        <td>{$caja['nombre']} {$caja['apellido']}</td>
        <td>
            <button class='btn btn-warning btn-sm edit-btn' data-id='{$caja['id_caja']}' data-toggle='modal' data-target='#editModal'><i class='fas fa-edit'></i></button>
            <button class='btn btn-danger btn-sm delete-btn' data-id='{$caja['id_caja']}'><i class='fas fa-trash-alt'></i></button>
        </td>
    </tr>";
}
?>
