<?php
require '../config.php';
$type = $_POST['type'];
$id = $_POST['id'];

if ($type == 'clients') {
    $query = $pdo->prepare("SELECT nombre, apellido FROM clientes WHERE id_cliente = ?");
} elseif ($type == 'autos') {
    $query = $pdo->prepare("SELECT nombre_habitacion, numero_habitacion, tipo FROM habitaciones WHERE id_habitacion = ?");
} else {
    echo json_encode(['status' => 'error', 'message' => 'Tipo no válido']);
    exit;
}

$query->execute([$id]);
$result = $query->fetch(PDO::FETCH_ASSOC);

if ($result) {
    if ($type == 'clients') {
        $name = $result['nombre'] . ' ' . $result['apellido'];
    } elseif ($type == 'autos') {
        $name = $result['nombre_habitacion'] . ' ' . $result['numero_habitacion'] . ' ' . $result['tipo'];
    }
    echo json_encode(['status' => 'success', 'name' => $name]);
} else {
    echo json_encode(['status' => 'error', 'message' => 'Entidad no encontrada']);
}
