<?php
session_start();
require '../config.php'; 
require '../functions.php'; 

if (!isset($_SESSION['usuario_id'])) {
    echo json_encode(['error' => 'Usuario no autenticado']);
    exit;
}

if (!isset($_GET['id_cuenta']) || !filter_var($_GET['id_cuenta'], FILTER_VALIDATE_INT)) {
    echo json_encode(['error' => 'ID de Cuenta no válido']);
    exit;
}

$id_cuenta = (int)$_GET['id_cuenta'];

$sql = "
    SELECT DISTINCT r.id_renta, r.fecha_renta, r.fecha_devolucion, r.precio_total,
           a.nombre_habitacion, a.numero_habitacion, a.tipo,
           u.nombre_usuario
    FROM rentas r
    INNER JOIN habitaciones a ON r.id_auto = a.id_habitacion
    INNER JOIN usuarios u ON r.id_usuario = u.id_usuario
    WHERE r.id_renta = :id_cuenta
    ORDER BY r.fecha_renta DESC
";

try {
    $stmt = $pdo->prepare($sql);
    $stmt->bindParam(':id_cuenta', $id_cuenta, PDO::PARAM_INT);
    $stmt->execute();
    $rentas = $stmt->fetchAll(PDO::FETCH_ASSOC);

    // Calcular el total de precios
    $total_precio = array_sum(array_column($rentas, 'precio_total'));

    // Formatear el total y los precios
    $total_precio_formateado = formatMonto($moneda, $total_precio);

    // Calcular los días entre fecha_renta y fecha_devolucion, y formatear las fechas
    foreach ($rentas as &$renta) {
        $fecha_renta_obj = new DateTime($renta['fecha_renta']);
        $fecha_devolucion_obj = new DateTime($renta['fecha_devolucion']);
        
        $renta['dias'] = $fecha_renta_obj->diff($fecha_devolucion_obj)->days; // Calcular días
        $renta['fecha_renta'] = $fecha_renta_obj->format('d \d\e M \d\e Y');
        $renta['fecha_devolucion'] = $fecha_devolucion_obj->format('d \d\e M \d\e Y');
        $renta['precio_total'] = formatMonto($moneda, $renta['precio_total']);
    }

    echo json_encode([
        'rentas' => $rentas,
        'total_precio' => $total_precio_formateado
    ]);
    exit;
} catch (PDOException $e) {
    echo json_encode(['error' => $e->getMessage()]);
    exit;
}
?>
