<?php
session_start();
require '../config.php';
require '../functions.php';
require '../PHPMailer/src/PHPMailer.php';
require '../PHPMailer/src/SMTP.php';
require '../PHPMailer/src/Exception.php';

use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;

if (!isset($_SESSION['usuario_id'])) {
    header('Location: ../index.php');
    exit;
}

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $id_cliente = $_POST['id_cliente'];
    $id_renta = $_POST['id_renta'];
    $monto = $_POST['monto'];
    $metodo_pago = $_POST['metodo_pago'];
    $fecha_pago = date('Y-m-d H:i:s');
    $fecha_pago2 = new DateTime(); // Crea un objeto DateTime con la fecha y hora actuales
    $hora_formateada = $fecha_pago2->format('h:i:s A'); // Formato de 12 horas con AM/PM
    $estado = 'check-out';

    // Obtén el ID del usuario desde la sesión
    $id_usuario = $_SESSION['usuario_id'];

    try {
        // Verificar si ya existe un pago para esta renta
        $sql_check = "SELECT COUNT(*) FROM pagos WHERE id_renta = ?";
        $stmt_check = $pdo->prepare($sql_check);
        $stmt_check->execute([$id_renta]);
        $pago_existente = $stmt_check->fetchColumn();

        if ($pago_existente > 0) {
            echo "<script>alert('Ya existe un pago registrado para esta renta.');</script>";
        } else {
            // Obtener la última caja aperturada
            $stmtCaja = $pdo->prepare("SELECT id_caja FROM caja WHERE tipo = 'apertura' ORDER BY fecha DESC LIMIT 1");
            $stmtCaja->execute();
            $caja = $stmtCaja->fetch(PDO::FETCH_ASSOC);

            if (!$caja) {
                echo 'Error: No se encontró una caja aperturada.';
                exit;
            }

            $id_caja = $caja['id_caja'];

            // Insertar el nuevo pago
            $sql = "INSERT INTO pagos (id_cliente, id_renta, id_usuario, monto, fecha_pago, metodo_pago, estado, caja_id) VALUES (?, ?, ?, ?, ?, ?, 'Completo', ?)";
            $stmt = $pdo->prepare($sql);
            $stmt->execute([$id_cliente, $id_renta, $id_usuario, $monto, $fecha_pago, $metodo_pago, $id_caja]);

            // Actualizar el estado del pago en la tabla renta
            $sql_update_renta = "UPDATE rentas SET pago = 'Completo', estado = 'Check-out', color = '#e74c3c', precio_total = $monto WHERE id_renta = ?";
            $stmt_update_renta = $pdo->prepare($sql_update_renta);
            $stmt_update_renta->execute([$id_renta]);
            

            // Obtener la información de la empresa
            $sql_empresa = "SELECT * FROM empresa LIMIT 1";
            $stmt_empresa = $pdo->prepare($sql_empresa);
            $stmt_empresa->execute();
            $empresa = $stmt_empresa->fetch(PDO::FETCH_ASSOC);

            // Obtener la información del cliente
            $sql_cliente = "SELECT nombre, apellido, email FROM clientes WHERE id_cliente = ?";
            $stmt_cliente = $pdo->prepare($sql_cliente);
            $stmt_cliente->execute([$id_cliente]);
            $cliente = $stmt_cliente->fetch(PDO::FETCH_ASSOC);

            // Consulta para obtener la información de los servicios junto con los datos de la reservación
            $sql_sr = "
                SELECT 
                    sr.id_servicio,
                    s.nombre,
                    s.precio,
                    sr.cantidad,
                    sr.total
                FROM 
                    servicios_reservacion sr
                INNER JOIN 
                    servicios s 
                ON 
                    sr.id_servicio = s.id_servicio
                WHERE 
                    sr.id_reservacion = ?";
                    
            $stmt_sr = $pdo->prepare($sql_sr);
            $stmt_sr->execute([$id_renta]);

            // Obtener los datos
            $servicios = $stmt_sr->fetchAll(PDO::FETCH_ASSOC);

            // Obtener la información de la renta (incluyendo fechas de renta y devolución)
            $sql_renta = "SELECT fecha_renta, fecha_devolucion, id_auto FROM rentas WHERE id_renta = ?";
            $stmt_renta = $pdo->prepare($sql_renta);
            $stmt_renta->execute([$id_renta]);
            $renta = $stmt_renta->fetch(PDO::FETCH_ASSOC);

            // Actualizar el estado del pago en la tabla renta
            if ($renta) {
                // Actualizar el estado de la habitacion a 'disponible' en la tabla habitaciones
                $sql_update_estado = "UPDATE habitaciones SET disponible = 'disponible' WHERE id_habitacion = ?";
                $stmt_update_estado = $pdo->prepare($sql_update_estado);
                $stmt_update_estado->execute([$renta['id_auto']]); // Corregido: pasar como un array
            } else {
                echo json_encode(['status' => 'error', 'message' => 'No se encontró la renta.']);
            }
            
            // Calcular los días de renta
            $fecha_renta = new DateTime($renta['fecha_renta']);
            $fecha_devolucion = new DateTime($renta['fecha_devolucion']);
            $intervalo = $fecha_renta->diff($fecha_devolucion);
            $dias_renta = $intervalo->days;

            // Generar el HTML del ticket
            ob_start();
            ?>
            <!DOCTYPE html>
            <html>
            <head>
                <title>Ticket de Pago</title>
                <style>
                    @page {
                        margin: 0;
                    }
                    body {
                        font-family: 'Courier New', monospace;
                        margin: 0;
                        padding: 0;
                    }
                    .ticket-container {
                        width: 300px; /* Ajusta el ancho según tus necesidades */
                        margin: 0 auto;
                        padding: 10px;
                        border: 1px solid #ddd;
                        font-size: 12px;
                        text-align: center;
                    }
                    .header {
                        margin-bottom: 10px;
                    }
                    .header h1 {
                        font-size: 14px;
                        margin: 0;
                    }
                    .header p {
                        margin: 2px 0;
                    }
                    .ticket-info {
                        text-align: left;
                        margin-top: 10px;
                    }
                    .ticket-info p {
                        margin: 5px 0;
                        display: flex;
                        justify-content: space-between;
                        font-size: 12px;
                    }
                    .ticket-info span {
                        display: inline-block;
                    }
                    .line {
                        border-top: 1px dashed #000;
                        margin: 10px 0;
                    }
                    .footer {
                        margin-top: 10px;
                        font-size: 10px;
                    }
                </style>
            </head>
            <body>
                <div class="ticket-container">
                    <div class="header">
                        <h1><?php echo htmlspecialchars($empresa['nombre']); ?></h1>
                        <p><?php echo htmlspecialchars($empresa['direccion']); ?></p>
                        <p><?php echo htmlspecialchars($empresa['estado']) . ', ' . htmlspecialchars($empresa['ciudad']); ?></p>
                        <p>Tel: <?php echo htmlspecialchars($empresa['telefono']); ?></p>
                        <p>Email: <?php echo htmlspecialchars($empresa['email']); ?></p>
                    </div>
                    <div class="ticket-info">
                        <div class="line"></div>
                        <p><span>ID Reserva:</span> <span><?php echo htmlspecialchars($id_renta); ?></span></p>
                        <p><span>Cliente:</span> <span><?php echo htmlspecialchars($cliente['nombre']) . ' ' . htmlspecialchars($cliente['apellido']); ?></span></p>
                        <p><span>Fecha de check-in:</span> <span><?php echo htmlspecialchars($renta['fecha_renta']); ?></span></p>
                        <p><span>Fecha de check-out:</span> <span><?php echo htmlspecialchars($renta['fecha_devolucion']); ?></span></p>
                        <p><span>Hora de check-out:</span> <span><?php echo htmlspecialchars($hora_formateada); ?></span></p>
                        <p><span>Estadía:</span> <span><?php echo htmlspecialchars($dias_renta); ?></span></p>
                        <!--<p><span>Monto:</span> <span><?php echo htmlspecialchars(formatMonto($moneda, $monto)); ?></span></p>-->
                        <p><span>Método:</span> <span><?php echo htmlspecialchars($metodo_pago); ?></span></p>
                        <p><span>Fecha Pago:</span> <span><?php echo htmlspecialchars($fecha_pago); ?></span></p>

                        <!-- Encabezado de los servicios -->
                        <h3>Detalles de Servicios:</h3>
                        <div class="line"></div>

                        <?php 
                        $totalServicios = 0; // Inicializamos el total de los servicios
                        foreach ($servicios as $servicio): 
                            $totalServicios += $servicio['total']; // Sumar el total de cada servicio
                        ?>
                            <div class="service-detail">
                                <p><span>Nombre:</span> <span><?php echo htmlspecialchars($servicio['nombre']); ?></span></p>
                                <p><span>Precio Unitario:</span> <span><?php echo htmlspecialchars(formatMonto($moneda, $servicio['precio'])); ?></span></p>
                                <p><span>Cantidad:</span> <span><?php echo htmlspecialchars($servicio['cantidad']); ?></span></p>
                                <p><span>Total:</span> <span><?php echo htmlspecialchars(formatMonto($moneda, $servicio['total'])); ?></span></p>
                                <div class="line"></div>
                            </div>
                        <?php endforeach; ?>

                        <!-- Mostrar el total de todos los servicios -->
                        <p><strong>Total de Servicios:</strong> <span><?php echo htmlspecialchars(formatMonto($moneda, $totalServicios)); ?></span></p>
                        <p><strong>Total General:</strong> <span><?php echo htmlspecialchars(formatMonto($moneda, $monto)); ?></span></p>
                    </div>

                    <div class="footer">
                        <p>Gracias por su pago.</p>
                    </div>
                </div>
            </body>
            </html>
            <?php
            $html_ticket = ob_get_clean();

            // Enviar el correo con el ticket
            $mail = new PHPMailer(true);

            try {
                // Configurar el servidor SMTP
                $mail->isSMTP();
                $mail->Host = 'mistertechpro.com'; // Servidor SMTP
                $mail->Port = 465; // Puerto SMTP seguro (SSL/TLS)
                $mail->SMTPAuth = true;
                $mail->Username = 'soporte@mistertechpro.com'; // Tu correo institucional
                $mail->Password = 'M1n1king2022$@$'; // Contraseña del correo institucional
                $mail->SMTPSecure = PHPMailer::ENCRYPTION_SMTPS; // Cifrado SSL/TLS
                $mail->CharSet = 'UTF-8';

                // Configuración del correo
                $mail->setFrom('soporte@mistertechpro.com', 'Renta de Autos');
                $mail->addAddress($cliente['email']); // Enviar al cliente
                $mail->isHTML(true); // Permitir HTML en el correo
                $mail->Subject = 'Ticket de Pago';
                $mail->Body = $html_ticket;

                $mail->send();
                echo 'Correo enviado exitosamente.';
            } catch (Exception $e) {
                echo 'Error al enviar el correo: ' . $mail->ErrorInfo;
            }

            // Imprimir el ticket (en una nueva ventana)
            echo " . $html_ticket . ";

            //echo "<script>alert('Pago registrado y ticket enviado.'); window.location.href='.php';</script>";
        }
    } catch (PDOException $e) {
        echo "Error: " . $e->getMessage();
    }
}
?>
