<?php
require '../config.php'; // Asegúrate de incluir la conexión PDO

try {
    $sql = "SELECT numero, COUNT(*) as cantidad 
            FROM ventas 
            WHERE DATE(fecha) = CURDATE() 
            GROUP BY numero 
            ORDER BY numero";
    
    $stmt = $pdo->prepare($sql);
    $stmt->execute();
    $ventas = $stmt->fetchAll(PDO::FETCH_ASSOC);

    echo json_encode($ventas);
} catch (PDOException $e) {
    echo json_encode(['error' => 'Error en la consulta']);
}
?>
