$(document).ready(function() {
    function cargarDatos() {
        $.ajax({
            url: 'obtener_datos.php',
            method: 'GET',
            dataType: 'json',
            success: function(data) {
                llenarTablaBoletos(data.boletos);
                llenarGraficoIngresos(data.ingresos);
                llenarTablaTotales(data.totales);
                llenarTablaNumeros(data.numeros);
            },
            error: function(xhr, status, error) {
                console.error('Error al cargar los datos:', error);
            }
        });
    }

    function llenarTablaBoletos(boletos) {
        var tbody = $('#tablaBoletos tbody');
        tbody.empty();
        var totalBoletos = 0;
        boletos.forEach(function(boleto) {
            var row = `<tr>
                <td>${boleto.turno}</td>
                <td>${boleto.vendedor}</td>
                <td>${boleto.boletos_vendidos.toLocaleString()}</td>
            </tr>`;
            tbody.append(row);
            totalBoletos += boleto.boletos_vendidos;
        });
        $('#totalBoletos').text(totalBoletos.toLocaleString());
    }

    function llenarGraficoIngresos(ingresos) {
        var ctx = document.getElementById('graficoIngresos').getContext('2d');
        new Chart(ctx, {
            type: 'bar',
            data: {
                labels: ingresos.labels,
                datasets: [{
                    label: 'Ingresos ($)',
                    data: ingresos.data,
                    backgroundColor: 'rgba(75, 192, 192, 0.2)',
                    borderColor: 'rgba(75, 192, 192, 1)',
                    borderWidth: 1
                }]
            },
            options: {
                scales: {
                    y: {
                        beginAtZero: true,
                        ticks: {
                            callback: function(value) {
                                return '$' + value.toLocaleString();
                            }
                        }
                    }
                },
                plugins: {
                    tooltip: {
                        callbacks: {
                            label: function(context) {
                                return '$' + context.raw.toLocaleString();
                            }
                        }
                    }
                }
            }
        });
    }

    function llenarTablaTotales(totales) {
        var tbody = $('#tablaTotales tbody');
        tbody.empty();
        var totalIngresos = 0, totalGanancias = 0;
        totales.forEach(function(total) {
            // Asegurar que los valores sean números válidos
            let ingresos = parseFloat(total.total_ingresos) || 0;
            let ganancias = parseFloat(total.ganancias) || 0;
    
            var row = `<tr>
                <td>${total.fecha}</td>
                <td>${ingresos.toLocaleString('en-US', { style: 'currency', currency: 'USD' })}</td>
                <td>${ganancias.toLocaleString('en-US', { style: 'currency', currency: 'USD' })}</td>
            </tr>`;
            tbody.append(row);
    
            totalIngresos += ingresos;
            totalGanancias += ganancias;
        });
    
        $('#totalIngresos').text(totalIngresos.toLocaleString('en-US', { style: 'currency', currency: 'USD' }));
        $('#totalGanancias').text(totalGanancias.toLocaleString('en-US', { style: 'currency', currency: 'USD' }));
    }
    

    function llenarTablaNumeros(numeros) {
        var tbody = $('#tablaNumeros tbody');
        tbody.empty();
        numeros.forEach(function(numero) {
            var row = `<tr>
                <td>${numero.vendedor}</td>
                <td>${numero.numero}</td>
                <td>${numero.valor.toLocaleString('en-US', { style: 'currency', currency: 'USD' })}</td>
                <td>${numero.fecha}</td>
            </tr>`;
            tbody.append(row);
        });
    }

    cargarDatos();
});