<?php
require '../config.php';

function backup_tables($pdo, $backupFile) {
    try {
        $tables = [];
        $result = $pdo->query("SHOW TABLES");
        while ($row = $result->fetch(PDO::FETCH_NUM)) {
            $tables[] = $row[0];
        }

        $sqlScript = "";

        foreach ($tables as $table) {
            // Obtener la estructura de la tabla
            $result = $pdo->query("SHOW CREATE TABLE $table");
            $row = $result->fetch(PDO::FETCH_NUM);
            $sqlScript .= "\n\n" . $row[1] . ";\n\n";

            // Obtener los datos de la tabla
            $result = $pdo->query("SELECT * FROM $table");
            $columnCount = $result->columnCount();

            for ($i = 0; $i < $columnCount; $i++) {
                while ($row = $result->fetch(PDO::FETCH_NUM)) {
                    $sqlScript .= "INSERT INTO $table VALUES(";
                    for ($j = 0; $j < $columnCount; $j++) {
                        $row[$j] = $row[$j] ? addslashes($row[$j]) : "NULL";
                        $row[$j] = str_replace("\n", "\\n", $row[$j]);
                        $sqlScript .= isset($row[$j]) ? '"' . $row[$j] . '"' : '""';
                        if ($j < ($columnCount - 1)) {
                            $sqlScript .= ',';
                        }
                    }
                    $sqlScript .= ");\n";
                }
            }

            $sqlScript .= "\n";
        }

        // Guardar el script SQL en un archivo
        file_put_contents($backupFile, $sqlScript);

        return true;
    } catch (Exception $e) {
        return $e->getMessage();
    }
}

$backupFile = '../backups/rentaautos_' . date('Y-m-d_H-i-s') . '.sql';
$result = backup_tables($pdo, $backupFile);

if ($result === true) {
    echo json_encode(['status' => 'success', 'file' => $backupFile]);
} else {
    echo json_encode(['status' => 'error', 'message' => "Error al crear el respaldo: $result"]);
}
?>
