<?php
session_start();
require '../config.php'; // Asegúrate de que este archivo configure la conexión PDO
require '../functions.php'; // Incluye funciones adicionales si las necesitas

// Verificar si el usuario está autenticado
if (!isset($_SESSION['usuario_id'])) {
    header('Location: ../clientes/crud_clientes.php');
    exit;
}

// Verificar si se ha recibido el id_cliente por GET
if (!isset($_GET['id_cliente']) || !filter_var($_GET['id_cliente'], FILTER_VALIDATE_INT)) {
    echo "<script>
            alert('No se ha especificado un cliente válido.');
            window.location.href = '../clientes/crud_clientes.php';
          </script>";
    exit;
}

$id_cliente = (int)$_GET['id_cliente']; // Asegurarse de que el ID sea un entero

// Consultar los detalles del cliente
try {
    $stmt = $pdo->prepare("SELECT * FROM clientes WHERE id_cliente = :id_cliente");
    $stmt->bindParam(':id_cliente', $id_cliente, PDO::PARAM_INT);
    $stmt->execute();
    $cliente = $stmt->fetch(PDO::FETCH_ASSOC);

    // Verificar si se encontró el cliente
    if (!$cliente) {
        echo "<script>
                alert('No se encontró un Cliente con el ID especificado.');
                window.location.href = '../clientes/crud_clientes.php';
              </script>";
        exit;
    }
} catch (PDOException $e) {
    echo "<script>
            alert('Error: " . $e->getMessage() . "');
            window.location.href = '../clientes/crud_clientes.php';
          </script>";
    exit;
}

// Manejar la solicitud AJAX para filtrar el historial de rentas
if (isset($_GET['action']) && $_GET['action'] == 'get_rentals') {
    $fecha_inicio = isset($_GET['fecha_inicio']) ? $_GET['fecha_inicio'] : null;
    $fecha_final = isset($_GET['fecha_final']) ? $_GET['fecha_final'] : null;

    $query = "SELECT r.*, a.marca, a.modelo, u.nombre_usuario 
              FROM rentas r
              JOIN autos a ON r.id_auto = a.id_auto
              JOIN usuarios u ON r.id_usuario = u.id_usuario
              WHERE r.id_cliente = :id_cliente";

    if ($fecha_inicio && $fecha_final) {
        $query .= " AND r.fecha_renta BETWEEN :fecha_inicio AND :fecha_final";
    }

    try {
        $stmt = $pdo->prepare($query);
        $stmt->bindParam(':id_cliente', $id_cliente, PDO::PARAM_INT);
        if ($fecha_inicio && $fecha_final) {
            $stmt->bindParam(':fecha_inicio', $fecha_inicio);
            $stmt->bindParam(':fecha_final', $fecha_final);
        }
        $stmt->execute();
        $rentas = $stmt->fetchAll(PDO::FETCH_ASSOC);

        echo json_encode($rentas);
        exit;
    } catch (PDOException $e) {
        echo json_encode(['error' => $e->getMessage()]);
        exit;
    }
}

?>



<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Estadías - Sistema Hotel</title>
    <link href="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/fullcalendar@6.1.5/dist/fullcalendar.min.css" rel="stylesheet">
    <style>
        .main-content {
            padding: 2rem;
        }
       
        #calendar {
            max-width: 1100px;
            margin: 0 auto;
        }
        .card {
            margin-bottom: 20px;
        }
        .input-group .form-control {
            border-right: 0;
        }
        .input-group .input-group-append .btn {
            border-left: 0;
        }
        .form-inline .form-control {
            width: auto;
        }
    </style>
</head>
<body>
    <?php include '../menu.php'; ?>

    <div class="main-content">
        <div class="d-flex align-items-center justify-content-center p-3 my-3 text-white bg-dark rounded shadow-sm">
            <div class="lh-1 text-center">
                <h2 class="mb-4 text-center">
                    <i class="fas fa-file-alt"></i> <!-- Icono de FontAwesome -->
                    Historial de Estadías
                </h2>
            </div>
        </div>

        <div class="row">
            <!-- Detalles del Cliente -->
            <div class="col-lg-4 mb-4">
                <div class="card">
                    <div class="card-body text-center">
                        <!-- Ícono grande de usuario -->
                        <i class="fa fa-user fa-5x"></i> <!-- Clase 'fa-5x' hace que el ícono sea grande -->

                        <h5 class="card-title mt-3"><?php echo htmlspecialchars($cliente['nombre'] . ' ' . $cliente['apellido']); ?></h5>
                        <a href="../clientes/crud_clientes.php" class="btn btn-primary mt-3">
                            <i class="fa fa-reply"></i> Regresar
                        </a>
                    </div>
                </div>

                <!-- Filtros de búsqueda -->
<div class="card">
    <div class="card-body">
        <div class="form-group">
            <label for="fecha_inicio">Fecha de Inicio:</label>
            <input type="date" id="fecha_inicio" class="form-control">
        </div>
        <div class="form-group">
            <label for="fecha_final">Fecha Final:</label>
            <input type="date" id="fecha_final" class="form-control">
            <input type="hidden" id="idCliente" class="form-control" value="<?php echo htmlspecialchars($id_cliente); ?>">
        </div>
        <button id="filtrar" class="btn btn-secondary"><i class="fas fa-filter"></i> Filtrar</button>

        <!-- Botón para generar el PDF del informe completo -->
        <a id="generatePdf" class="btn btn-info" target="_blank">
            <i class="fas fa-file-pdf"></i> Generar PDF
        </a>

        <script>
            function updatePdfLink() {
                var idCliente = encodeURIComponent(document.getElementById('idCliente').value);
                var fechaInicio = encodeURIComponent(document.getElementById('fecha_inicio').value);
                var fechaFin = encodeURIComponent(document.getElementById('fecha_final').value);

                // Generar el enlace del PDF con los parámetros de fecha e id_cliente
                var pdfLink = '../reportes/historial_pdf.php?fecha_inicio=' + fechaInicio + '&fecha_fin=' + fechaFin + '&id_cliente=' + idCliente;
                document.getElementById('generatePdf').setAttribute('href', pdfLink);
            }

            // Actualizar el enlace del PDF al cargar la página
            updatePdfLink();

            // Actualizar el enlace del PDF cuando cambien los filtros
            document.getElementById('fecha_inicio').addEventListener('change', updatePdfLink);
            document.getElementById('fecha_final').addEventListener('change', updatePdfLink);
        </script>
    </div>
</div>

            </div>

            <!-- Lista de Archivos -->
            <div class="col-lg-8">
                <div class="card">
                    <div class="card-header bg-primary text-white">
                        Historial de Rentas
                    </div>
                    <div class="card-body">
                    
                        <div id="archivos-lista" class="mt-3">
                            <!-- La lista de archivos se cargará aquí -->
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/fullcalendar@6.1.5/dist/fullcalendar.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@4.5.2/dist/js/bootstrap.bundle.min.js"></script>
    <script type="text/javascript">
        // Establecer la variable id_cliente en JavaScript
        var id_cliente = <?php echo json_encode($id_cliente); ?>;
    </script>
    <script type="text/javascript" src="historial.js"></script>
</body>
</html>
