<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Inicio de sesion</title>
    <link rel="shortcut icon" href="img/favi.ico">
    <link href="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css">
    <style>
        body {
            background-color: #f8f9fa;
            display: flex;
            align-items: center;
            justify-content: center;
            height: 100vh;
            margin: 0;
        }
        .container {
            max-width: 400px;
        }
        .card {
            border-radius: 15px;
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.2);
            padding: 20px;
            text-align: center;
            background-color: #fff;
        }
        .card-header {
            background-color: #007bff;
            color: #fff;
            font-size: 1.5rem;
            font-weight: bold;
            border-bottom: 2px solid #0056b3;
            padding: 10px;
        }
        .btn-primary {
            background-color: #007bff;
            border-color: #007bff;
        }
        .btn-primary:hover {
            background-color: #0056b3;
            border-color: #004085;
        }
        .alert {
            display: none;
            margin-bottom: 15px;
        }
        .btn-icon {
            display: flex;
            align-items: center;
            justify-content: center;
        }
        .btn-icon i {
            margin-right: 8px;
        }
        .img-thumbnail {
            max-width: 150px;
            margin: 20px 0;
            border: none;
        }
        .form-group {
            text-align: left; /* Alinea los textos a la izquierda */
        }
        .form-control {
            text-align: left; /* Alinea el texto de los campos de entrada a la izquierda */
        }
        .form-group label {
            text-align: left; /* Alinea la etiqueta a la izquierda */
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="card">
            <div class="card-header">
            Entrada al sistema
            </div>
            <?php
            // Obtener el logo de la base de datos
            require 'config.php';
            $sql = 'SELECT logo, nombre FROM empresa LIMIT 1';
            $stmt = $pdo->prepare($sql);
            $stmt->execute();
            $empresa = $stmt->fetch(PDO::FETCH_ASSOC);
            $logo = htmlspecialchars($empresa['logo']); // Nombre del archivo del logo
            $nombre_empresa = htmlspecialchars($empresa['nombre']);
            ?>
            <?php if ($logo): ?>
                <div class="text-center">
                    <img src="img/<?php echo $logo; ?>" alt="Logo de la Empresa" class="img-thumbnail">
                </div>
            <?php endif; ?>
            <div class="card-body">
                <div class="alert alert-danger" id="error-message"></div>
                <form id="login-form">
                    <div class="form-group">
                        <label for="nombre_usuario">Nombre de Usuario</label>
                        <input type="text" name="nombre_usuario" id="nombre_usuario" class="form-control" placeholder="Ingrese su nombre de usuario" required autocomplete="off">
                    </div>
                    <div class="form-group">
                        <label for="contra">Contraseña</label>
                        <input type="password" name="contra" id="contra" class="form-control" placeholder="Ingrese su contraseña" required>
                    </div>
                    <button type="submit" class="btn btn-primary btn-block btn-icon">
                        <i class="fas fa-sign-in-alt"></i> Ingresar
                    </button>
                </form>
            </div>
        </div>
    </div>

    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="login.js"></script>
</body>
</html>
