<?php
require 'config.php';

try {
    // Datos del usuario por defecto
    $nombre_usuario = 'admin';
    $contra = 'admin'; // Cambia por una contraseña segura
    $nombre = 'Administrador';
    $apellido = 'Por Defecto';
    $email = 'admin@ejemplo.com';
    $rol = 'Administrador';

    // Encriptar la contraseña
    $contra_hash = password_hash($contra, PASSWORD_DEFAULT);

    // Insertar el usuario en la base de datos
    $sql = 'INSERT INTO usuarios (nombre_usuario, contra, nombre, apellido, email, rol) 
            VALUES (:nombre_usuario, :contra, :nombre, :apellido, :email, :rol)';

    $stmt = $pdo->prepare($sql);
    
    $stmt->bindParam(':nombre_usuario', $nombre_usuario);
    $stmt->bindParam(':contra', $contra_hash);
    $stmt->bindParam(':nombre', $nombre);
    $stmt->bindParam(':apellido', $apellido);
    $stmt->bindParam(':email', $email);
    $stmt->bindParam(':rol', $rol);

    $stmt->execute();

    echo 'Usuario por defecto insertado exitosamente.';
} catch (PDOException $e) {
    echo 'Error: ' . $e->getMessage();
}
?>
