<?php
session_start();
require 'config.php';

header('Content-Type: application/json');

$response = ['status' => 'error', 'message' => ''];

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $nombre_usuario = trim($_POST['nombre_usuario']);
    $contra = trim($_POST['contra']);

    if (empty($nombre_usuario) || empty($contra)) {
        $response['message'] = 'Por favor, complete ambos campos.';
        echo json_encode($response);
        exit;
    }

    $stmt = $pdo->prepare('SELECT * FROM usuarios WHERE nombre_usuario = ?');
    $stmt->execute([$nombre_usuario]);
    $usuario = $stmt->fetch();

    if ($usuario && password_verify($contra, $usuario['contra'])) {
        $_SESSION['usuario_id'] = $usuario['id_usuario'];
        $_SESSION['rifa'] = $usuario['rifa'];
        $_SESSION['comision'] = $usuario['comision'];
        $_SESSION['usuario'] = $usuario['nombre_usuario'];
        $_SESSION['rol'] = $usuario['rol'];
        $response['status'] = 'success';
        $response['redirect'] = 'dashboard/dashboard.php';
        if ($usuario['rol'] == 'admin') {
            $response['redirect'] = 'dashboard/dashboard.php';
        } elseif ($usuario['rol'] == 'vendedor') {
            $response['redirect'] = 'ventas/panel_vendedor.php';
        } else {
            $response['message'] = 'Rol no válido.';
        }
    } else {
        $response['message'] = 'Nombre de usuario o contraseña incorrectos.';
    }
} else {
    $response['message'] = 'Método no permitido.';
}

echo json_encode($response);
?>
