<?php
require '../config.php';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $id_pago = $_POST['id_pago'];

    $sql = "SELECT p.*, c.nombre AS cliente_nombre, c.apellido AS cliente_apellido, u.nombre AS usuario_nombre, u.apellido AS usuario_apellido 
            FROM pagos p
            JOIN clientes c ON p.id_cliente = c.id_cliente
            JOIN usuarios u ON p.id_usuario = u.id_usuario
            WHERE p.id_pago = :id_pago";
    $stmt = $pdo->prepare($sql);
    $stmt->execute(['id_pago' => $id_pago]);
    $pago = $stmt->fetch(PDO::FETCH_ASSOC);

    if ($pago) {
        echo json_encode(['status' => 'success', 'data' => $pago]);
    } else {
        echo json_encode(['status' => 'error', 'message' => 'No se encontró el pago.']);
    }
}
?>
