<?php
require '../config.php';
require '../functions.php';
session_start();

if (!isset($_SESSION['usuario_id'])) {
    header('Location: ../index.php');
    exit;
}

if (isset($_GET['id_pago'])) {
    $id_pago = $_GET['id_pago'];

    // Obtener información del pago
    $sql = "SELECT p.*, c.nombre AS cliente_nombre, c.apellido AS cliente_apellido, e.nombre AS empresa_nombre, e.direccion AS empresa_direccion, e.estado AS empresa_estado, e.ciudad AS empresa_ciudad, e.telefono AS empresa_telefono, e.email AS empresa_email, r.fecha_renta, r.fecha_devolucion
            FROM pagos p
            JOIN clientes c ON p.id_cliente = c.id_cliente
            JOIN empresa e ON 1=1
            JOIN rentas r ON p.id_renta = r.id_renta
            WHERE p.id_pago = ?";
    $stmt = $pdo->prepare($sql);
    $stmt->execute([$id_pago]);
    $pago = $stmt->fetch(PDO::FETCH_ASSOC);

    if ($pago) {
        // Calcular los días de renta
        $fecha_renta = new DateTime($pago['fecha_renta']);
        $fecha_devolucion = new DateTime($pago['fecha_devolucion']);
        $intervalo = $fecha_renta->diff($fecha_devolucion);
        $dias_renta = $intervalo->days;
        $hora_devolucion = new DateTime($pago['fecha_pago']);
        $hora_formateada = $hora_devolucion->format('h:i:s A'); // Formato de 12 horas con AM/PM

        // Generar el HTML del ticket
        ?>
<!DOCTYPE html>
<html>
<head>
    <title>Ticket de Pago</title>
    <style>
        @page {
            margin: 0;
        }
        body {
            font-family: 'Courier New', monospace;
            margin: 0;
            padding: 0;
        }
        .ticket-container {
            width: 300px; /* Ajusta el ancho según tus necesidades */
            margin: 0 auto;
            padding: 10px;
            border: 1px solid #ddd;
            font-size: 12px;
            text-align: center;
        }
        .header {
            margin-bottom: 10px;
        }
        .header h1 {
            font-size: 14px;
            margin: 0;
        }
        .header p {
            margin: 2px 0;
        }
        .ticket-info {
            text-align: left;
            margin-top: 10px;
        }
        .ticket-info p {
            margin: 5px 0;
            display: flex;
            justify-content: space-between;
            font-size: 12px;
        }
        .ticket-info span {
            display: inline-block;
        }
        .line {
            border-top: 1px dashed #000;
            margin: 10px 0;
        }
        .footer {
            margin-top: 10px;
            font-size: 10px;
        }
    </style>
</head>
<body>
    <div class="ticket-container">
        <div class="header">
            <h1><?php echo htmlspecialchars($pago['empresa_nombre']); ?></h1>
            <p><?php echo htmlspecialchars($pago['empresa_direccion']); ?></p>
            <p><?php echo htmlspecialchars($pago['empresa_estado']) . ', ' . htmlspecialchars($pago['empresa_ciudad']); ?></p>
            <p>Tel: <?php echo htmlspecialchars($pago['empresa_telefono']); ?></p>
            <p>Email: <?php echo htmlspecialchars($pago['empresa_email']); ?></p>
        </div>
        <div class="ticket-info">
            <div class="line"></div>
            <p><span>ID Pago:</span> <span><?php echo htmlspecialchars($pago['id_pago']); ?></span></p>
            <p><span>Cliente:</span> <span><?php echo htmlspecialchars($pago['cliente_nombre']) . ' ' . htmlspecialchars($pago['cliente_apellido']); ?></span></p>
            <p><span>Fecha Renta:</span> <span><?php echo htmlspecialchars($pago['fecha_renta']); ?></span></p>
            <p><span>Fecha de Devolución:</span> <span><?php echo htmlspecialchars($pago['fecha_devolucion']); ?></span></p>
            <p><span>Hora de Devolución:</span> <span><?php echo htmlspecialchars($hora_formateada); ?></span></p>
            <p><span>Días de Renta:</span> <span><?php echo htmlspecialchars($dias_renta); ?></span></p>
            <p><span>Monto:</span> <span><?php echo htmlspecialchars(formatMonto($moneda, $pago['monto'])); ?></span></p>
            <p><span>Metodo:</span> <span><?php echo htmlspecialchars($pago['metodo_pago']); ?></span></p>
            <p><span>Fecha Pago:</span> <span><?php echo htmlspecialchars($pago['fecha_pago']); ?></span></p>
        </div>
        <div class="footer">
            <p>Gracias por su pago.</p>
        </div>
    </div>
</body>
</html>
        <?php
    } else {
        echo 'No se encontró el pago.';
    }
} else {
    echo 'ID de pago no especificado.';
}
?>
