<?php
session_start();
require '../config.php';
require '../functions.php';

// Verifica los permisos del usuario para ver, editar y eliminar
$usuario_id = $_SESSION['usuario_id'];
$permisos = [
    'ver' => usuarioTienePermiso($pdo, $usuario_id, 'ver_clientes'),
    'editar' => usuarioTienePermiso($pdo, $usuario_id, 'editar_clientes'),
    'eliminar' => usuarioTienePermiso($pdo, $usuario_id, 'borrar_clientes'),
];

// Obtener término de búsqueda y sanitizar
$search = isset($_POST['search']) ? trim($_POST['search']) : '';
$pagina = isset($_POST['pagina']) ? (int)$_POST['pagina'] : 1;
$registrosPorPagina = 10;  // Ajusta el número de registros por página según sea necesario
$inicio = ($pagina - 1) * $registrosPorPagina;

// Función para obtener los pagos con paginación
function getPagos($pdo, $inicio, $registrosPorPagina, $search = '') {
    $sql = "SELECT p.id_pago, p.monto, p.fecha_pago, p.metodo_pago, p.estado, 
                   c.nombre AS cliente_nombre, c.apellido AS cliente_apellido, 
                   u.nombre_usuario AS nombre_usuario
            FROM pagos p
            JOIN clientes c ON p.id_cliente = c.id_cliente
            JOIN usuarios u ON p.id_usuario = u.id_usuario
            WHERE CONCAT(p.id_pago, ' ', c.nombre, ' ', c.apellido, ' ', u.nombre, ' ', u.apellido, ' ', p.monto, ' ', p.fecha_pago, ' ', p.metodo_pago, ' ', p.estado) LIKE :search
            ORDER BY p.id_pago DESC
            LIMIT :inicio, :registrosPorPagina";
    $stmt = $pdo->prepare($sql);
    $searchParam = "%$search%";
    $stmt->bindValue(':search', $searchParam, PDO::PARAM_STR);
    $stmt->bindValue(':inicio', (int)$inicio, PDO::PARAM_INT);
    $stmt->bindValue(':registrosPorPagina', (int)$registrosPorPagina, PDO::PARAM_INT);
    $stmt->execute();
    return $stmt->fetchAll(PDO::FETCH_ASSOC);
}


// Función para obtener el número total de pagos
function getTotalPagos($pdo, $search = '') {
    $sql = "SELECT COUNT(*) 
            FROM pagos p
            JOIN clientes c ON p.id_cliente = c.id_cliente
            JOIN usuarios u ON p.id_usuario = u.id_usuario
            WHERE CONCAT(p.id_pago, ' ', c.nombre, ' ', c.apellido, ' ', u.nombre, ' ', u.apellido, ' ', p.monto, ' ', p.fecha_pago, ' ', p.metodo_pago, ' ', p.estado) LIKE :search";
    $stmt = $pdo->prepare($sql);
    $searchParam = "%$search%";
    $stmt->bindValue(':search', $searchParam, PDO::PARAM_STR);
    $stmt->execute();
    return $stmt->fetchColumn();
}

// Obtener los pagos
$pagos = getPagos($pdo, $inicio, $registrosPorPagina, $search);

// Obtener el total de pagos para la paginación
$totalPagos = getTotalPagos($pdo, $search);
$totalPaginas = ceil($totalPagos / $registrosPorPagina);

// Mostrar los resultados
if (empty($pagos)) {
    echo '<tr><td colspan="8" class="text-center">No se encontró ningún pago.</td></tr>';
} else {
    foreach ($pagos as $pago) {
        echo '<tr>';
        echo '<td>' . htmlspecialchars($pago['id_pago']) . '</td>';
        echo '<td>' . htmlspecialchars($pago['cliente_nombre'] . ' ' . $pago['cliente_apellido']) . '</td>';
        echo '<td>' . htmlspecialchars(formatMonto($moneda, $pago['monto'])) . '</td>';
        echo '<td>' . htmlspecialchars($pago['fecha_pago']) . '</td>';
        echo '<td>' . htmlspecialchars($pago['metodo_pago']) . '</td>';
        echo '<td>' . htmlspecialchars($pago['nombre_usuario']) . '</td>';
        echo '<td>' . htmlspecialchars($pago['estado']) . '</td>';
        echo '<td>';
        // Generar botones basados en permisos
        if ($permisos['editar']) {
        echo '<button class="btn btn-warning btn-sm edit-btn" data-id="' . $pago['id_pago'] . '" data-toggle="modal" data-target="#editModal"><i class="fas fa-edit"></i></button>';
        }
        if ($permisos['eliminar']) {
        echo '<button class="btn btn-danger btn-sm delete-btn" data-id="' . $pago['id_pago'] . '"><i class="fas fa-trash-alt"></i></button>';
        }
        if ($permisos['ver']) {
        echo '<button class="btn btn-success btn-sm reprint-btn" data-id="' . $pago['id_pago'] . '"><i class="fas fa-print"></i></button>';
    }
        echo '</td>';
        echo '</tr>';
    }
}
?>
