<?php
session_start();
require '../config.php';
require '../functions.php';

// Verifica si el usuario está autenticado
if (!isset($_SESSION['usuario_id'])) {
    echo json_encode([]);
    exit;
}


// Obtener términos de búsqueda y fechas
$search = isset($_POST['search']) ? trim($_POST['search']) : '';
$fechaInicio = isset($_POST['fecha_inicio']) ? $_POST['fecha_inicio'] : '';
$fechaFin = isset($_POST['fecha_fin']) ? $_POST['fecha_fin'] : '';

// Definir el número de registros por página
$registrosPorPagina = 10;
$paginacion = isset($_POST['page']) ? (int)$_POST['page'] : 1;
$inicio = ($paginacion - 1) * $registrosPorPagina;

// Modificar consulta SQL para manejar la búsqueda general y filtros 
$sql = "
    SELECT rentas.id_renta, clientes.nombre AS nombre_cliente, clientes.apellido AS apellido_cliente, 
           habitaciones.nombre_habitacion AS marca_auto, habitaciones.numero_habitacion AS modelo_auto, habitaciones.tipo AS modelo_anio, 
           usuarios.nombre_usuario, rentas.fecha_renta, rentas.fecha_devolucion, rentas.precio_total, 
           rentas.estado, rentas.pago, DATEDIFF(rentas.fecha_devolucion, rentas.fecha_renta) AS dias_renta
    FROM rentas
    JOIN clientes ON rentas.id_cliente = clientes.id_cliente
    JOIN habitaciones ON rentas.id_auto = habitaciones.id_habitacion
    JOIN usuarios ON rentas.id_usuario = usuarios.id_usuario
    WHERE 1";

if ($search) {
    $sql .= " AND CONCAT(clientes.nombre, ' ', clientes.apellido, ' ', habitaciones.nombre_habitacion, ' ', habitaciones.numero_habitacion, ' ', usuarios.nombre_usuario) LIKE :search";
}
if ($fechaInicio) {
    $sql .= " AND rentas.fecha_renta >= :fecha_inicio";
}
if ($fechaFin) {
    $sql .= " AND rentas.fecha_renta <= :fecha_fin";
}

// Agregar la cláusula ORDER BY y LIMIT para paginación
$sql .= " ORDER BY rentas.id_renta DESC LIMIT :inicio, :registrosPorPagina";

$stmt = $pdo->prepare($sql);
if ($search) {
    $stmt->bindValue(':search', "%$search%");
}
if ($fechaInicio) {
    $stmt->bindValue(':fecha_inicio', $fechaInicio);
}
if ($fechaFin) {
    $stmt->bindValue(':fecha_fin', $fechaFin);
}
$stmt->bindValue(':inicio', (int)$inicio, PDO::PARAM_INT);
$stmt->bindValue(':registrosPorPagina', (int)$registrosPorPagina, PDO::PARAM_INT);

// Ejecutar consulta y obtener resultados
$stmt->execute();
$rentas = $stmt->fetchAll(PDO::FETCH_ASSOC);

// Contar el total de registros para la paginación
$totalSql = "
    SELECT COUNT(*)
    FROM rentas
    JOIN clientes ON rentas.id_cliente = clientes.id_cliente
    JOIN autos ON rentas.id_auto = autos.id_auto
    JOIN usuarios ON rentas.id_usuario = usuarios.id_usuario
    WHERE 1";

if ($search) {
    $totalSql .= " AND CONCAT(clientes.nombre, ' ', clientes.apellido, ' ', autos.marca, ' ', autos.modelo, ' ', usuarios.nombre_usuario) LIKE :search";
}
if ($fechaInicio) {
    $totalSql .= " AND rentas.fecha_registro >= :fecha_inicio";
}
if ($fechaFin) {
    $totalSql .= " AND rentas.fecha_registro <= :fecha_fin";
}

$totalStmt = $pdo->prepare($totalSql);
if ($search) {
    $totalStmt->bindValue(':search', "%$search%");
}
if ($fechaInicio) {
    $totalStmt->bindValue(':fecha_inicio', $fechaInicio);
}
if ($fechaFin) {
    $totalStmt->bindValue(':fecha_fin', $fechaFin);
}
$totalStmt->execute();
$totalRegistros = $totalStmt->fetchColumn();
$totalPaginas = ceil($totalRegistros / $registrosPorPagina);

// Generar el HTML de la tabla
if (empty($rentas)) {
    echo '<tr><td colspan="10" class="text-center">No se encontraron resultados.</td></tr>';
} else {
    foreach ($rentas as $renta) {
        $badgeClass = $renta['pago'] === 'Pendiente' ? 'badge-danger' : 'badge-success';
        
        echo '<tr>';
        echo '<td>' . htmlspecialchars($renta['id_renta']) . '</td>';
        echo '<td>' . htmlspecialchars($renta['nombre_cliente'] . ' ' . $renta['apellido_cliente']) . '</td>';
        echo '<td>' . htmlspecialchars($renta['marca_auto'] . ' ' . $renta['modelo_auto']. ' ' . $renta['modelo_anio']) . '</td>';
        echo '<td>' . htmlspecialchars(formatearFecha($renta['fecha_renta'])) . '</td>';
        echo '<td>' . htmlspecialchars(formatearFecha($renta['fecha_devolucion'])) . '</td>';
        echo '<td><span class="badge badge-primary">' . htmlspecialchars($renta['dias_renta']) . '</span></td>';
        echo '<td>' . htmlspecialchars(formatMonto($moneda, $renta['precio_total'])) . '</td>';
        echo '<td>' . htmlspecialchars($renta['estado']) . '</td>';
        echo '<td><span class="badge ' . htmlspecialchars($badgeClass) . '">' . htmlspecialchars($renta['pago']) . '</span></td>';
        echo '<td>' . htmlspecialchars($renta['nombre_usuario']) . '</td>';
        echo '</tr>';
    }
}
?>
