<?php
// Incluir manualmente los archivos de PHPMailer
require '../PHPMailer/src/PHPMailer.php';
require '../PHPMailer/src/SMTP.php';
require '../PHPMailer/src/Exception.php';

use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;

require '../config.php'; // Configuración de la base de datos
require '../functions.php'; // Funciones auxiliares

function enviarCorreosDevolucionHoy($pdo) {
    $fechaActual = date('Y-m-d');
    $sql = "
    SELECT clientes.email, clientes.nombre, clientes.apellido, autos.marca, autos.modelo, autos.anio, autos.placa, rentas.fecha_devolucion, rentas.fecha_registro 
    FROM rentas
    JOIN clientes ON rentas.id_cliente = clientes.id_cliente
    JOIN autos ON rentas.id_auto = autos.id_auto
    WHERE rentas.fecha_devolucion = :fecha_actual";
    
    $stmt = $pdo->prepare($sql);
    $stmt->bindValue(':fecha_actual', $fechaActual);
    $stmt->execute();
    $rentasDevolucionHoy = $stmt->fetchAll(PDO::FETCH_ASSOC);

    foreach ($rentasDevolucionHoy as $renta) {
        $email = $renta['email'];
        $nombre = $renta['nombre'];
        $apellido = $renta['apellido'];
        $auto = $renta['marca'] . ' ' . $renta['modelo'] . ' ' . $renta['anio'] . ' (' . $renta['placa'] . ')';
        $fechaDevolucion = date('d-m-Y', strtotime($renta['fecha_devolucion']));
        $horaDevolucion = date('H:i', strtotime($renta['fecha_registro']));

        // Crear una instancia de PHPMailer
        $mail = new PHPMailer(true);

        try {
            // Configurar el servidor SMTP
            $mail->isSMTP();
            $mail->Host = 'mistertechpro.com'; // Servidor SMTP
            $mail->Port = 465; // Puerto SMTP seguro (SSL/TLS)
            $mail->SMTPAuth = true;
            $mail->Username = 'soporte@mistertechpro.com'; // Tu correo institucional
            $mail->Password = 'M1n1king2022$@$'; // Contraseña del correo institucional
            $mail->SMTPSecure = PHPMailer::ENCRYPTION_SMTPS; // Cifrado SSL/TLS
            $mail->CharSet = 'UTF-8';

            // Configuración del correo
            $mail->setFrom('soporte@mistertechpro.com', 'Renta de Autos');
            $mail->addAddress($email); // Enviar al cliente
            $mail->isHTML(true); // Permitir HTML en el correo

            // Asunto y cuerpo del correo
            $mail->Subject = 'Recordatorio de Devolución de Vehículo';

            // Cuerpo HTML del correo
            $mail->Body = "
                <div style='font-family: Arial, sans-serif; color: #333;'>
                    <h2 style='color: #007BFF;'>Recordatorio de Devolución de Vehículo</h2>
                    <p>Estimado(a) <strong>$nombre $apellido</strong>,</p>
                    <p>Le recordamos que el vehículo <strong>$auto</strong> debe ser devuelto <strong>hoy, $fechaDevolucion</strong> a las <strong>$horaDevolucion</strong>.</p>
                    <p>Por favor, asegúrese de entregarlo en las mejores condiciones.</p>
                    <hr>
                    <p style='color: #777;'>Si tiene alguna duda, no dude en contactarnos.</p>
                    <p><strong>Renta de Autos</strong><br>Tel: +123 456 7890<br>Email: soporte@mistertechpro.com</p>
                </div>
            ";

            // Enviar el correo
            $mail->send();
        } catch (Exception $e) {
            // Manejo de errores
            echo "El mensaje no pudo ser enviado. Error: {$mail->ErrorInfo}";
        }
    }

    echo "Correos enviados exitosamente.";
}

// Llamar a la función de envío de correos
enviarCorreosDevolucionHoy($pdo);
?>
