<?php
session_start();
require '../config.php';
require '../functions.php';

// Verifica los permisos del usuario para ver, editar y eliminar
$usuario_id = $_SESSION['usuario_id'];
$permisos = [
    'ver' => usuarioTienePermiso($pdo, $usuario_id, 'ver_rentas'),
    'editar' => usuarioTienePermiso($pdo, $usuario_id, 'editar_rentas'),
    'eliminar' => usuarioTienePermiso($pdo, $usuario_id, 'borrar_rentas'),
];

// Obtener término de búsqueda y sanitizar
$search = isset($_POST['search']) ? trim($_POST['search']) : '';

// Definir el número de registros por página
$registrosPorPagina = 10;

// Obtener el número de página actual
$paginacion = isset($_POST['page']) ? (int)$_POST['page'] : 1;
$inicio = ($paginacion - 1) * $registrosPorPagina;

// Modificar consulta SQL para manejar la búsqueda general
$sql = "
    SELECT rentas.id_renta, clientes.nombre AS nombre_cliente, clientes.apellido AS apellido_cliente, habitaciones.nombre_habitacion AS marca_auto, habitaciones.numero_habitacion AS modelo_auto, habitaciones.tipo AS modelo_anio, usuarios.nombre_usuario, 
           rentas.fecha_renta, rentas.fecha_devolucion, rentas.precio_total, rentas.estado, rentas.pago, 
           DATEDIFF(rentas.fecha_devolucion, rentas.fecha_renta) AS dias_renta
    FROM rentas
    JOIN clientes ON rentas.id_cliente = clientes.id_cliente
    JOIN habitaciones ON rentas.id_auto = habitaciones.id_habitacion
    JOIN usuarios ON rentas.id_usuario = usuarios.id_usuario
    WHERE CONCAT(clientes.nombre, ' ', clientes.apellido, ' ', habitaciones.nombre_habitacion, ' ', habitaciones.numero_habitacion, ' ', usuarios.nombre_usuario, ' ', rentas.fecha_renta, ' ', rentas.fecha_devolucion, ' ', rentas.precio_total, ' ', rentas.estado) LIKE :search
    ORDER BY rentas.id_renta DESC
    LIMIT :inicio, :registrosPorPagina";

$stmt = $pdo->prepare($sql);
$stmt->bindValue(':search', "%$search%");
$stmt->bindValue(':inicio', (int)$inicio, PDO::PARAM_INT);
$stmt->bindValue(':registrosPorPagina', (int)$registrosPorPagina, PDO::PARAM_INT);

// Ejecutar consulta
$stmt->execute();

// Obtener resultados
$rentas = $stmt->fetchAll(PDO::FETCH_ASSOC);

// Contar el total de registros
$totalSql = "
    SELECT COUNT(*) 
    FROM rentas
    JOIN clientes ON rentas.id_cliente = clientes.id_cliente
    JOIN habitaciones ON rentas.id_auto = habitaciones.id_habitacion
    JOIN usuarios ON rentas.id_usuario = usuarios.id_usuario
    WHERE CONCAT(clientes.nombre, ' ', clientes.apellido, ' ', habitaciones.nombre_habitacion, ' ', habitaciones.numero_habitacion, ' ', usuarios.nombre_usuario, ' ', rentas.fecha_renta, ' ', rentas.fecha_devolucion, ' ', rentas.precio_total, ' ', rentas.estado) LIKE :search";
$totalStmt = $pdo->prepare($totalSql);
$totalStmt->bindValue(':search', "%$search%");
$totalStmt->execute();
$totalRegistros = $totalStmt->fetchColumn();
$totalPaginas = ceil($totalRegistros / $registrosPorPagina);

// Verificar si se encontraron rentas
if (empty($rentas)) {
    echo '<tr><td colspan="10" class="text-center">No se encontraron resultados.</td></tr>';
} else {
    // Mostrar los resultados
    foreach ($rentas as $renta) {
        // Asignar la clase del badge según el estado del pago
        $badgeClass = $renta['pago'] === 'Pendiente' ? 'badge-danger' : 'badge-success';
        
        echo '<tr>';
        echo '<td>' . htmlspecialchars($renta['id_renta']) . '</td>';
        echo '<td>' . htmlspecialchars($renta['nombre_cliente'] . ' ' . $renta['apellido_cliente']) . '</td>';
        echo '<td>' . htmlspecialchars($renta['marca_auto'] . ' ' . $renta['modelo_auto']. ' ' . $renta['modelo_anio']) . '</td>';
        echo '<td>' . htmlspecialchars(formatearFecha($renta['fecha_renta'])) . '</td>';
        echo '<td>' . htmlspecialchars(formatearFecha($renta['fecha_devolucion'])) . '</td>';
        echo '<td> <span class="badge badge-primary">' . htmlspecialchars($renta['dias_renta']) . '</span></td>';
        echo '<td>' . htmlspecialchars(formatMonto($moneda, $renta['precio_total'])) . '</td>';
        echo '<td>' . htmlspecialchars($renta['estado']) . '</td>';
        echo '<td><span class="badge ' . htmlspecialchars($badgeClass) . '">' . htmlspecialchars($renta['pago']) . '</span></td>';
        echo '<td>' . htmlspecialchars($renta['nombre_usuario']) . '</td>';
        echo '<td>
        <div class="btn-group" role="group">';

            if ($permisos['editar']) {
                echo '<button class="btn btn-warning btn-sm edit-btn" data-id="' . htmlspecialchars($renta['id_renta']) . '" data-toggle="modal" data-target="#editModal" title="Editar renta" data-toggle="tooltip">
                        <i class="fas fa-edit"></i>
                    </button>';
            }

            if ($permisos['eliminar']) {
                echo '<button class="btn btn-danger btn-sm delete-btn" data-id="' . htmlspecialchars($renta['id_renta']) . '" title="Eliminar renta" data-toggle="tooltip">
                        <i class="fas fa-trash-alt"></i>
                    </button>';
            }

            if ($permisos['ver']) {
                /*echo '<button class="btn btn-info btn-sm print-btn" onclick="window.open(\'../reportes/print_contract.php?id_renta=' . htmlspecialchars($renta['id_renta']) . '\', \'_blank\')" title="Imprimir contrato" data-toggle="tooltip">
                        <i class="fas fa-print"></i>
                    </button>';*/
            }

            if ($permisos['editar']) {
                echo '<a class="btn btn-info btn-sm up-btn mr-2" href="../cuenta/crud_cuenta.php?id_cuenta=' . $renta['id_renta'] . '" title="Ver Cuenta" data-toggle="tooltip">
                <i class="fa fa-address-card"></i>
              </a>';
        
            }

            echo '  </div>
                </td>';


                    echo '</tr>';
                }
            }
?>
