<?php
require '../config.php';

$fechaInicio = $_GET['fecha_inicio'] ?? date('Y-m-d');
$fechaFin = $_GET['fecha_fin'] ?? date('Y-m-d');

$sql = "SELECT hs.id_sorteo, t.nombre AS turno, hs.numero_ganador, hs.fecha, u.nombre AS usuario 
        FROM historial_sorteos hs
        JOIN turnos t ON hs.id_turno = t.id_turno
        JOIN usuarios u ON hs.usuario_id = u.id_usuario
        WHERE hs.fecha BETWEEN :fechaInicio AND :fechaFin
        ORDER BY hs.fecha DESC";

$stmt = $pdo->prepare($sql);
$stmt->execute([
    ':fechaInicio' => $fechaInicio . ' 00:00:00',
    ':fechaFin' => $fechaFin . ' 23:59:59'
]);

$sorteos = $stmt->fetchAll(PDO::FETCH_ASSOC);

echo json_encode($sorteos);
?>
