<?php
require '../config.php'; // Conexión PDO

// Obtener filtros del formulario
$fechaInicio = $_POST['fechaInicio'] ?? '';
$fechaFin = $_POST['fechaFin'] ?? '';
$id_turno = $_POST['id_turno'] ?? '';
$id_usuario = $_POST['id_usuario'] ?? '';

// Construir la consulta SQL dinámicamente
$query = "SELECT v.id_venta, u.nombre_usuario, t.nombre AS turno, v.cliente, v.valor, v.ganancia, v.comision, v.numero, v.fecha 
          FROM ventas v
          JOIN usuarios u ON v.id_vendedor = u.id_usuario
          JOIN turnos t ON v.id_turno = t.id_turno
          WHERE 1 = 1"; // Para evitar problemas con AND

$params = [];

// Filtrar por fecha si está presente
if (!empty($fechaInicio) && !empty($fechaFin)) {
    $query .= " AND v.fecha BETWEEN :fechaInicio AND :fechaFin + INTERVAL 1 DAY - INTERVAL 1 SECOND";
    $params[':fechaInicio'] = $fechaInicio;
    $params[':fechaFin'] = $fechaFin;
}

// Filtrar por turno si se selecciona
if (!empty($id_turno)) {
    $query .= " AND v.id_turno = :id_turno";
    $params[':id_turno'] = $id_turno;
}

// Filtrar por usuario si se selecciona
if (!empty($id_usuario)) {
    $query .= " AND v.id_vendedor = :id_usuario";
    $params[':id_usuario'] = $id_usuario;
}

$stmt = $pdo->prepare($query);
$stmt->execute($params);

$ventas = $stmt->fetchAll(PDO::FETCH_ASSOC);

// Inicializar los totales
$totalValor = 0;
$totalGanancia = 0;
$totalComision = 0; // Si la comisión es un porcentaje de la ganancia

// Construir la tabla con los resultados
$html = "";
foreach ($ventas as $venta) {
    // Supongamos que la comisión es un 10% de la ganancia
    $comision = $venta['comision'];
    
    $html .= "<tr>
                <td>{$venta['turno']}</td>
                <td>{$venta['nombre_usuario']}</td>
                <td>{$venta['numero']}</td>
                <td>\${$venta['valor']}</td>
                <td>\${$venta['ganancia']}</td>
                <td>\${$venta['comision']}</td>
                <td>{$venta['fecha']}</td>
              </tr>";

    // Acumulando los totales
    $totalValor += $venta['valor'];
    $totalGanancia += $venta['ganancia'];
    $totalComision += $comision;
}

// Devolver los resultados y los totales en formato JSON
echo json_encode([
    'html' => $html ?: "<tr><td colspan='7' class='text-center'>No se encontraron resultados</td></tr>",
    'totalValor' => number_format($totalValor, 2),
    'totalGanancia' => number_format($totalGanancia, 2),
    'totalComision' => number_format($totalComision, 2)
]);
?>
