<?php
session_start();
require '../config.php';

// Verificar si el usuario está autenticado
if (!isset($_SESSION['usuario_id'])) {
    header('Location: ../index.php');
    exit;
}


?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Reporte del Sorteo</title>
    <link rel="shortcut icon" href="../img/favi.ico">
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
    <style>
    #cargando {
        position: fixed;
        top: 50%;
        left: 50%;
        transform: translate(-50%, -50%);
        z-index: 1000;
        background: rgba(255, 255, 255, 0.9);
        padding: 20px;
        border-radius: 10px;
        box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
    }
    .spinner-border {
        width: 3rem;
        height: 3rem;
    }
</style>
</head>
<body>
    <?php include '../menu.php'; ?>
    <div class="content">
    <div class="container mt-4">
        <div class="card shadow">
            <div class="card-header bg-primary text-white text-center">
                <h4><i class="fas fa-trophy"></i> Reporte de Sorteos</h4>
            </div>
            <div class="card-body">
                <!-- Contenedor para el spinner y mensaje de carga -->
<div id="cargando" class="text-center" style="display: none;">
    <div class="spinner-border text-primary" role="status">
        <span class="sr-only">Cargando...</span>
    </div>
    <p class="mt-2">Cargando información...</p>
</div>
            <form id="filtroVentas" class="mb-3">
    <div class="form-row">
        <div class="form-group col-md-2">
            <label for="fechaInicio">Fecha Inicial:</label>
            <input type="date" id="fechaInicio" name="fechaInicio" class="form-control">
        </div>
        <div class="form-group col-md-2">
            <label for="fechaFin">Fecha Final:</label>
            <input type="date" id="fechaFin" name="fechaFin" class="form-control">
        </div>
        <div class="form-group col-md-3">
            <label for="id_turno">Turno:</label>
            <select id="id_turno" name="id_turno" class="form-control">
                <option value="" disabled selected>Seleccionar</option>
                <!-- Opciones de turnos se llenarán con AJAX -->
            </select>
        </div>
        <div class="form-group col-md-3">
            <label for="id_usuario">Usuario:</label>
            <select id="id_usuario" name="id_usuario" class="form-control">
                <option value="" disabled selected>Seleccionar</option>
                <!-- Opciones de usuarios se llenarán con AJAX -->
            </select>
        </div>

        <!-- Botón de Buscar -->
        <div class="form-group col-md-1 d-flex align-items-end">
            <button type="submit" class="btn btn-primary btn-block">
                <i class="fas fa-search"></i>
            </button>
        </div>

        <!-- Botón de Generar PDF -->
        <div class="form-group col-md-1 d-flex align-items-end">
            <a href="#" id="generarPDF" class="btn btn-success btn-block">
                <i class="fas fa-print"></i> PDF
            </a>
        </div>
    </div>
</form>


                <!-- Tabla para mostrar las ventas -->
                <table class="table table-bordered table-striped">
                    <thead class="thead-dark">
                        <tr>
                            <th>Turno</th>
                            <th>Vendedor</th>
                            <th>Numero</th>
                            <th>Valor</th>
                            <th>Premio</th>
                            <th>Comisión</th>
                            <th>Fecha</th>
                        </tr>
                    </thead>
                    <tbody id="tablaVentas">
                        <!-- Los datos se llenarán con AJAX -->
                    </tbody>
                    <tfoot>
                        <tr class="bg-primary text-white font-weight-bold">
                            <td colspan="3" class="text-right">Total General:</td>
                            <td id="totalValor">$0.00</td>
                            <td id="totalGanancia">$0.00</td>
                            <td id="totalComision">$0.00</td>
                            <td></td>
                        </tr>
                    </tfoot>
                </table>
                

            </div>
        </div>
    </div>
    </div>
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.11.6/dist/umd/popper.min.js"></script>
    <script src="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>
    <script>
        document.addEventListener("DOMContentLoaded", function() {
        // Obtener la fecha actual
        const today = new Date().toISOString().split('T')[0];

        // Establecer la fecha actual en los campos de fecha
        document.getElementById('fechaInicio').value = today;
        document.getElementById('fechaFin').value = today;

        // Botón de Generar PDF
    document.getElementById("generarPDF").addEventListener("click", function (e) {
        e.preventDefault(); // Evitar el comportamiento predeterminado del enlace

        // Obtener los valores de los filtros
        const fechaInicio = document.getElementById("fechaInicio").value;
        const fechaFin = document.getElementById("fechaFin").value;
        const idTurno = document.getElementById("id_turno").value;
        const idUsuario = document.getElementById("id_usuario").value;

        // Construir la URL con los parámetros
        const url = `../reportes/rep_sorteo.php?fechaInicio=${fechaInicio}&fechaFin=${fechaFin}&id_turno=${idTurno}&id_usuario=${idUsuario}`;

        // Abrir la URL en una nueva pestaña
        window.open(url, "_blank");
    });
    });
    
    $(document).ready(function () {
    // Cargar opciones de turnos y usuarios
    cargarFiltros();

    // Manejar el formulario de filtros
    $("#filtroVentas").submit(function (event) {
        event.preventDefault();
        cargarVentas();
    });

    // Función para cargar opciones de turnos y usuarios
    function cargarFiltros() {
        $.ajax({
            url: "get_filtros.php",
            method: "GET",
            dataType: "json",
            success: function (data) {
                $("#id_turno").append(data.turnos);
                $("#id_usuario").append(data.usuarios);
            }
        });
    }

    // Función para cargar ventas
    function cargarVentas() {
        // Mostrar el spinner y mensaje de carga
        $("#cargando").show();

        $.ajax({
            url: "get_ventas.php",
            method: "POST",
            data: $("#filtroVentas").serialize(),
            dataType: "json",
            success: function (response) {
                // Rellenar la tabla
                $("#tablaVentas").html(response.html);

                // Actualizar los totales
                $("#totalValor").text(`$${response.totalValor}`);
                $("#totalGanancia").text(`$${response.totalGanancia}`);
                $("#totalComision").text(`$${response.totalComision}`);
            },
            complete: function () {
                // Ocultar el spinner y mensaje de carga
                $("#cargando").hide();
            },
            error: function () {
                // En caso de error, también ocultar el spinner
                $("#cargando").hide();
                alert("Ocurrió un error al cargar los datos.");
            }
        });
    }
});

    </script>
</body>
</html>
