<?php
session_start();
include '../config.php';

$session_id = session_id();
$sql = "SELECT * FROM carrito WHERE session_id = ?";
$stmt = $pdo->prepare($sql);
$stmt->execute([$session_id]);
$items = $stmt->fetchAll(PDO::FETCH_ASSOC);

$html = "";
$total = 0; // Variable para el total

foreach ($items as $item) {
    $total += $item['valor']; // Sumar el valor de cada apuesta

    $html .= "<tr>
                <td>{$item['numero']}</td>
                <td>{$item['cliente']}</td>
                <td>\${$item['valor']}</td>
                <td><button class='btn btn-danger btn-sm eliminarCarrito' data-id='{$item['id']}'>X</button></td>
              </tr>";
}

// Agregar la fila del total
$html .= "<tr style='font-weight: bold; font-size: 20px; background-color: #f8f9fa;'>
            <td colspan='2' class='text-end'>Total:</td>
            <td>\$" . number_format($total, 2) . "</td>
            <td></td>
          </tr>";

echo $html;

?>
