<?php
require '../config.php';

session_start();
$id_vendedor = $_SESSION['usuario_id'];

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $id_turno = $_POST['id_turno'];

    // Generar lista de números del 00 al 99
    $numeros = array_map(function ($num) {
        return ['numero' => sprintf('%02d', $num), 'vendido' => false]; // Asegura dos dígitos
    }, range(0, 99));

    // Consultar la hora de fin del turno
    $stmt = $pdo->prepare("SELECT hora_fin FROM turnos WHERE id_turno = :id_turno");
    $stmt->bindParam(':id_turno', $id_turno, PDO::PARAM_INT);
    $stmt->execute();
    $turno = $stmt->fetch(PDO::FETCH_ASSOC);

    if (!$turno) {
        echo json_encode(["status" => "error", "message" => "Turno no encontrado."]);
        exit;
    }

    // Ajustar zona horaria y obtener hora actual
    date_default_timezone_set('America/El_Salvador'); // Ajusta según tu país
    $hora_actual = new DateTime(date('H:i:s'));
    $hora_fin = new DateTime($turno['hora_fin']);

    // Verificar si el turno ha vencido
    $turno_vencido = ($hora_actual > $hora_fin);

    // Consultar ventas por número en el turno seleccionado y por el vendedor actual
    $stmt = $pdo->prepare("SELECT numero, SUM(valor) as total_ventas 
    FROM ventas 
    WHERE id_turno = :id_turno 
    AND id_vendedor = :id_vendedor 
    AND DATE(fecha) = CURDATE()  -- Asegura que solo seleccione las ventas de hoy
    GROUP BY numero");

    $stmt->bindParam(':id_turno', $id_turno, PDO::PARAM_INT);
    $stmt->bindParam(':id_vendedor', $id_vendedor, PDO::PARAM_INT);
    $stmt->execute();
    $ventas = $stmt->fetchAll(PDO::FETCH_ASSOC);

    // Crear un array con los números que han alcanzado los 30 dólares en ventas
    $numeros_vendidos = [];
    foreach ($ventas as $venta) {
        if ($venta['total_ventas'] >= 30) {
            $numeros_vendidos[] = sprintf('%02d', $venta['numero']); // Asegura el formato 00-99
        }
    }

    // Marcar los números que han alcanzado los 30 dólares como vendidos
    foreach ($numeros as &$num) {
        if (in_array($num['numero'], $numeros_vendidos)) {
            $num['vendido'] = true;
        }
    }

    echo json_encode([
        "status" => "success",
        "numeros" => $numeros,
        "turno_vencido" => $turno_vencido
    ]);
    exit;
}

echo json_encode(["status" => "error", "message" => "Petición inválida"]);
?>