<?php
require '../config.php'; // Conexión a la base de datos

header('Content-Type: application/json');

try {
    // Obtener SOLO LA ÚLTIMA VENTA (última venta registrada)
    $query_venta = "SELECT 
                        v.id_venta, 
                        t.nombre AS nombre_turno, 
                        v.numero, 
                        v.cliente, 
                        v.valor, 
                        v.ganancia, 
                        v.fecha, 
                        u.nombre AS nombre_vendedor,
                        v.correlativo
                    FROM ventas v
                    JOIN turnos t ON v.id_turno = t.id_turno
                    JOIN usuarios u ON v.id_vendedor = u.id_usuario
                    ORDER BY v.id_venta DESC 
                    LIMIT 1";  // SOLO UNA VENTA

    $stmt = $pdo->prepare($query_venta);
    $stmt->execute();
    $venta = $stmt->fetch(PDO::FETCH_ASSOC);

    if ($venta) {
        // Devolver un array con una sola venta
        echo json_encode([
            'status' => 'success', 
            'ventas' => [$venta], 
            'correlativo' => $venta['correlativo']
        ]);
    } else {
        echo json_encode(['status' => 'error', 'message' => 'No hay ventas registradas.']);
    }
} catch (PDOException $e) {
    echo json_encode(['status' => 'error', 'message' => 'Error en la base de datos: ' . $e->getMessage()]);
}
?>