$(document).ready(function () {
    $("#imprimirUltimaVenta").click(async function () {
        try {
            let datos = await obtenerUltimaVenta();
            if (!datos || datos.ventas.length === 0) {
                Swal.fire({
                    icon: 'error',
                    title: 'Error',
                    text: 'No hay ventas registradas.',
                    showConfirmButton: true
                });
                return;
            }

            // SOLO ENVIAR LA PRIMERA VENTA (la última registrada)
            generarTicket([datos.ventas[0]], datos.correlativo);
        } catch (error) {
            console.error("Error al obtener la última venta:", error);
            Swal.fire({
                icon: 'error',
                title: 'Error inesperado',
                text: 'No se pudo obtener la última venta.',
                showConfirmButton: true
            });
        }
    });
});

// Función para obtener la última venta
async function obtenerUltimaVenta() {
    try {
        let response = await fetch('obtener_ultima_venta.php');
        let data = await response.json();
        return data.status === "success" ? data : null;
    } catch (error) {
        console.error("Error en la solicitud AJAX:", error);
        return null;
    }
}

// Función para generar e imprimir el ticket con SOLO UNA VENTA
function generarTicket(ventas, correlativo) {
    // Tomar solo la primera venta del array
    const venta = ventas[0];
    
    let ticketHTML = `
        <html>
        <head>
            <title></title>
            <style>
                /* ELIMINAR COMPLETAMENTE ENCABEZADOS Y PIES DE PÁGINA */
                @page {
                    margin: 0mm !important;
                    padding: 0mm !important;
                    size: 50mm auto;
                }
                
                @media print {
                    /* Eliminar encabezados del navegador */
                    @page {
                        margin: 0mm !important;
                        margin-top: 0mm !important;
                        margin-bottom: 0mm !important;
                        margin-left: 0mm !important;
                        margin-right: 0mm !important;
                        padding: 0mm !important;
                        size: 50mm auto;
                    }
                    
                    /* Ocultar cualquier header/footer del navegador */
                    body::before,
                    body::after {
                        display: none !important;
                        content: none !important;
                    }
                }
                
                /* Estilos del ticket */
                body { 
                    font-family: 'Courier New', monospace; 
                    font-size: 8px;
                    margin: 0mm !important;
                    padding: 2mm !important;
                    width: 46mm;
                    line-height: 1;
                    background: white;
                    -webkit-print-color-adjust: exact;
                    print-color-adjust: exact;
                }
                .ticket {
                    width: 46mm;
                    margin: 0;
                    padding: 0;
                }
                .linea { 
                    margin: 0; 
                    padding: 0; 
                    line-height: 1;
                    font-size: 8px;
                }
                .centro { text-align: center; }
                .negrita { font-weight: bold; }
                .separador { 
                    border-top: 1px dashed #000; 
                    margin: 1mm 0; 
                    padding: 0;
                }
                .espacio { margin: 0.5mm 0; }
                .titulo {
                    font-size: 9px;
                    font-weight: bold;
                    margin: 1mm 0;
                }
            </style>
        </head>
        <body>
            <div class="ticket">
                <div class="linea centro titulo">TICKET DE VENTA</div>
                <div class="linea centro negrita">Correlativo: ${correlativo}</div>
                <div class="separador"></div>
                <div class="linea espacio"><span class="negrita">ID:</span> ${venta.id_venta}</div>
                <div class="linea espacio"><span class="negrita">Turno:</span> ${venta.nombre_turno}</div>
                <div class="linea espacio"><span class="negrita">No:</span> ${venta.numero}</div>
                <div class="linea espacio"><span class="negrita">Cliente:</span> ${venta.cliente}</div>
                <div class="linea espacio"><span class="negrita">Valor:</span> $${parseFloat(venta.valor).toFixed(2)}</div>
                <div class="linea espacio"><span class="negrita">Ganancia:</span> $${parseFloat(venta.ganancia).toFixed(2)}</div>
                <div class="linea espacio"><span class="negrita">Fecha:</span> ${venta.fecha}</div>
                <div class="linea espacio"><span class="negrita">Vendedor:</span> ${venta.nombre_vendedor}</div>
                <div class="separador"></div>
                <div class="linea centro">¡Gracias por su compra!</div>
            </div>

            <script>
                // ELIMINAR ENCABEZADOS Y PIES DE PÁGINA
                window.onload = function() {
                    // Configurar impresión sin encabezados
                    const style = document.createElement('style');
                    style.textContent = \`
                        @page {
                            margin: 0mm !important;
                            margin-top: 0mm !important;
                            margin-bottom: 0mm !important;
                            margin-left: 0mm !important;
                            margin-right: 0mm !important;
                            padding: 0mm !important;
                            size: 50mm auto;
                        }
                        body {
                            margin: 0mm !important;
                            padding: 2mm !important;
                        }
                    \`;
                    document.head.appendChild(style);
                    
                    // Imprimir inmediatamente
                    setTimeout(() => {
                        window.print();
                        // Cerrar después de imprimir
                        setTimeout(() => window.close(), 300);
                    }, 100);
                };
            </script>
        </body>
        </html>`;

    // Crear ventana sin barras de herramientas
    let ventana = window.open(
        '', 
        'ticket_print',
        'width=200,height=400,left=100,top=100,toolbar=no,menubar=no,scrollbars=no,status=no,location=no'
    );
    
    ventana.document.write(ticketHTML);
    ventana.document.close();
}