<?php
require '../config.php';
session_start();

// Verificar si el usuario está autenticado
if (!isset($_SESSION['usuario_id'])) {
    echo json_encode(['status' => 'error', 'message' => 'Usuario no autenticado.']);
    exit;
}

$id_vendedor = $_SESSION['usuario_id'];

// Obtener el turno actual
try {
    // Obtener el turno activo
    $sql_turno = "SELECT id_turno, nombre, hora_inicio, hora_fin FROM turnos WHERE hora_inicio <= CURTIME() AND hora_fin >= CURTIME() LIMIT 1";
    $stmt_turno = $pdo->prepare($sql_turno);
    $stmt_turno->execute();
    $turno = $stmt_turno->fetch(PDO::FETCH_ASSOC);

    if (!$turno) {
        echo json_encode(['status' => 'error', 'message' => 'No hay turno activo en este momento.']);
        exit;
    }

    // Obtener el id del turno activo
    $id_turno = $turno['id_turno'];

    // Obtener las ventas del vendedor para el turno activo y el día actual, incluyendo la comisión
    $sql = "SELECT v.id_venta, v.numero, v.cliente, v.valor, v.ganancia, v.comision, t.nombre AS turno, v.fecha
            FROM ventas v
            JOIN turnos t ON v.id_turno = t.id_turno
            WHERE v.id_vendedor = :id_vendedor
            AND v.id_turno = :id_turno
            AND DATE(v.fecha) = CURDATE() -- Filtra solo las ventas de hoy
            ORDER BY v.fecha DESC";

    $stmt = $pdo->prepare($sql);
    $stmt->bindParam(':id_vendedor', $id_vendedor, PDO::PARAM_INT);
    $stmt->bindParam(':id_turno', $id_turno, PDO::PARAM_INT);  // Corregir aquí
    $stmt->execute();
    $ventas = $stmt->fetchAll(PDO::FETCH_ASSOC);

    // Enviar las ventas en la respuesta JSON
    echo json_encode(["status" => "success", "ventas" => $ventas]);

} catch (PDOException $e) {
    // Manejar errores de la base de datos
    echo json_encode(['status' => 'error', 'message' => 'Error en la base de datos: ' . $e->getMessage()]);
} catch (Exception $e) {
    // Manejar otros errores
    echo json_encode(['status' => 'error', 'message' => 'Error: ' . $e->getMessage()]);
}
?>
